#include "addon.h"
typedef enum bool { FALSE, TRUE } bool;
extern void set(bool);

#include <stdio.h>
#include <string.h>
extern int getopt __P((int __argc,char *__const * __argv,__const char *__opts));
extern int opterr;
extern int optind;
extern int optopt;
extern char *optarg;

void b_getopt(char** argv) {
    int c, argc=0;
    char* flags;

/*Count No. args*/
    while (argv[argc]!=0)
        argc++;

/*Check No. args*/
    if (argc<2) {
       fprintf(stderr, "usage: %s flag-specification arg-list\n", argv[0]);
       set(FALSE);
    }

/*Store location of the flags (arg 1), then shift*/
    flags=argv[1];
    argv[1]=argv[0];
    argv++;
    argc--;

/*Print flags (assumes multiple whitespace collapsed in cmd substitution)*/
    while ((c=getopt(argc, argv, flags)) != EOF) {
        if (c=='?') { set(FALSE); return; }
        printf("-%c %s ", c, index(flags, c)[1] == ':' ? optarg : "");
    }

/*Print rest of options*/
    printf("-- ");
    for (argv+=optind; *argv; argv++)
        printf("%s ", *argv);
    set(TRUE);
    return;
}
