/* 
   config.h: defines the pathnames of relevant files,
   process names, other settings.. 
   --------------------------------------------------
*/

/*
        The destination of the configuration files, also mentioned
	in the build-script
*/
#define CONFDIM     "/conf/dim/"

                        /*      The version and the year */
#define VERSION         "1.03"
#define YEAR            "1994"


                        /* the copy of the original getty definitions file 
			   see examples directory for a sample
                        */
#define ORGGETTY        CONFDIM "getty.ttyS3.org"

                        /* the file named beyond is used to disable 
			   auto-answers by the modem. 
			*/
#define DISABLEGETTY 	CONFDIM "getty.ttyS3.dis"

                        /* the file getty uses for its definition */
#define DESTGETTY	"/etc/default/getty.ttyS3"

                        /* the login program */
#define LOGIN		"/bin/login"

                        /* the error-log file */
#define ERRLOG		"/usr/adm/dim.log"

                        /* the panic-log file, incase ERRLOG logging fails */
#define PANICLOG	"/dev/console"

                        /* command to list processes.. must lead to the 
			   process number in the first column, and the process
			   with its arguments, used in resetting (uu)getty
                           to a new state
                        */
#define PSCMD		"ps -ax"
   
                        /* process string of the (uu)getty process, used in 
			   resetting (uu)getty for a new definition file. 
			   Note that PSCMD (above) must show this string, 
			   when (uu)getty is running.. Check this carefully!
                        */
#define GETTYSTRING	"/etc/getty ttyS3 modem vt100"

                        /* e-mail address of sysadm which user can mail upon 
			   failure, displayed by error logging functions. 
			   Leave undefined if you don't want callback
                           to display the message that the person can be 
			   e-mailed in case of trouble
                         */   

/*      Undefined now!
#define EMAIL			"frank@icce.rug.nl"   
*/
