/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
#include "rss.h"

void listdestinations(int uid, int all)
{
    int
	dindex,
	gindex;
    DESTINATION_
	*dp;
    unsigned 
	groupidx;
						/* walk the groups */

                                                /* all listings suppressed */
    if (!show_destinations && !show_direct && !show_extra)
        return;

    printf("\n"
	    "Callback destinations for %s:\n"
	    "----------------------------------\n", user[uid].name);

    for (gindex = 0; gindex < user[uid].ngroups; gindex++)
    {						
	groupidx = user[uid].groups[gindex];	/* point to the group */

						/* walk the destinations */
	for (dindex = 0; dindex < ndestinations; dindex++)
	{
	    dp = &destination[dindex];		/* use local pointer */

            switch (dp->mode)                   /* decide what to display */
            {
                case extra_mode:                /* extra not wanted */
                    if (!show_extra)
                        continue;
                break;

                case direct_mode:               /* direct not wanted */
                    if (!show_direct)
                        continue;
                break;

                case phone_mode:                /* destinations not wanted */
                    if (!show_destinations)
                        continue;
                break;
            }

	    if (groupidx == dp->group)		/* group found */
	    {
		printf("%15s ", target[dp->target].target);/* show target */
			
		if (all)
		{
		    printf("-- %s\n", dp->modevalue);
		    if (dp->filename)
			printf("%15c -- %s\n", ' ', dp->filename);
		}
		else
		    printf("\n");
	    }
	}
    }
}
