/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
#include "rss.h"

void reinit()
{
    FILE
    	*pslist;
    char
	*cp,
	modembase[256],
    	buf[256];
    int
	killed = 0,
    	pid;

    if (!kill_processes)
    {
	log(log_on, "Reinit prevented by 'nokills'");
	return;
    }

    if (!(pslist = popen (PSCMD, "r")))
    	error("Can't get processes list");

						/* look for a slash */
    if (cp = strrchr(filename[the_modemfile], '/'))
	cp++;
    else
	cp = filename[the_modemfile];

    strcpy(modembase, cp);			/* copy the modem process */

    while (fgets(buf, 255, pslist))
    {
	if (strstr(buf, modembase))
	{
	    if (!sscanf(buf, " %d", &pid))
	    	error ("Can't find PID in ps-output \"%s\"", buf);

	    if (kill(pid, SIGHUP))
	    	error("Can't kill(%d, SIGHUP) in \"%s\"", pid, buf);

	    log(log_on, "SIGHUP received by %s", filename[the_modemfile]);
	    killed++;
	}
    }

    if (!killed)
	log(log_on, "Couldn't find %s to kill SIGHUP.",
	    filename[the_modemfile]);

    pclose(pslist);
}
    
