/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
#include "rss.h"

/*
    Make a new default file for target 'index'
*/
void makenewdef(int uid, int tid)
{
    register FILE
    	*inf,
    	*outf;
    char
    	buf [300];
    register char
    	*fname,
	*marker;

    /*
	the source is either the name from the phonelist index, or when
	not given: the default callback definitions file
    */
    fname =
	(destination[tid].filename) ?	    /* sourcefile may be specified   */
	    destination[tid].filename	    /* or standard, depending on the */
	:				    /* targetdefinition		     */
	    filename[the_cbfile];

    inf = xfopen(fname, "r");		    /* open the callback-file	    */

    outf = xfopen (filename[the_tmpfile], "w");	/* and the temporary file   */
    	
    while (1)
    {
    	fgets(buf, 299, inf);			/* read input line */

    	if (feof(inf))				/* at EOF? */
	    break;				/* done.. */
    	    
    	if (!(marker = strstr(buf, MARKER)))	/* is there no $PHONE */
    	    fprintf (outf, buf);		/* then copy the line	*/
    	else					/* otherwise, insert phonenr */
    	{	
	    fwrite(buf, marker - buf, 1, outf);	/* copy what's before marker */
	    fprintf
	    (
		outf, "%s%s",			/* append the phonenumber */
			destination[tid].modevalue,
			marker + strlen(MARKER)	/* and the trailing info */
	    );
    	}
    }
    
    fclose (inf);
    fclose (outf);
}
