/* Copyright (C) 1995
            Olav Woelfelschneider (wosch@rbg.informatik.th-darmstadt.de)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <unistd.h>
#include <sys/types.h>
#ifndef hpux
#include <getopt.h>
#endif
#include <string.h>
#include <stdio.h>
#include <malloc.h>

#include "printer.h"
#include "decoder.h"

char *myname;
int debug;
const char *const version="version 1.2";

typedef struct family_t {
  const char *name;
  void (*decode)(char *fname, int printer);
  int printer;
} family_t;


family_t family[] = {
  "g3tobj",  g3_decode,  PRT_BJ,
  "g3tolq",  g3_decode,  PRT_LQ,
  "pnmtobj", pnm_decode, PRT_BJ,
  "pnmtolq", pnm_decode, PRT_LQ,
  NULL, 0, 0,
};


int main (int argc, char **argv) {
  int opt,i;
  int formfeed;

  lowres = 0;
  debug = 0;
  formfeed = 1;

  if ((myname = strrchr (argv[0], '/'))) myname++; else myname=argv[0];

  while ((opt = getopt (argc, argv, "dflw:h:x:y:?")) != EOF) {
    switch (opt) {
    case 'd':
      debug = 1;
      break;

    case 'f':
      formfeed = 0;
      break;

    case 'w':
      scale_x = atoi(optarg);
      break;

    case 'h':
      scale_y = atoi(optarg);
      break;

    case 'x':
      offs_x = atoi(optarg);
      break;

    case 'y':
      offs_y = atoi(optarg);
      break;

    case 'l':
      lowres = 1;
      break;

    case '?':
      fprintf(stderr, "%s %s\n"
      "Usage: %s [-?] [-d] [-f] [-l] [-w <x-scale*1000>] [-h <y-scale*1000>]\n"
      "\t\t[-x <x-offset*1000>] [-y <y-offset*1000>] [<file>]\n"
      "   Offsets are given in inch * 1000, scales are from 1000 to 2000.\n",
	      myname, version, myname);
      exit(1);
    }
  }

  i=0;
  while(family[i].name) {
    if (strcmp(family[i].name, myname)==0) {
      (family[i].decode)(argv[optind], family[i].printer);
      if (formfeed) putchar(12);
      exit(0);
    }
    i++;
  }
  fprintf(stderr, "%s: Huh? Dunno who I am!\n", myname);
  exit(1);
}


