/*
 * NAME
 *   SplitArticle.c
 * USAGE
 *   Usage: SplitArticle ArticleFile HeaderFile BodyFile
 * DESCRIPTION
 *   Split a news article into it's header and it's body.
 * COPYRIGHT
 *   Skim - Off-line news reading package optimized for slow lines.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   Skim version 0.6.
 */

#include <stdio.h>
#include <ctype.h>

#include "VarBuf.h"
#include "Skim.h"

FILE_ID("/home/rene/sys/CVS_MasterSourceRepository/skim/SplitArticle.c,v 1.15 1995/08/15 19:33:37 rpijlman Exp");

int main( int argc, char ** argv )
{
    Boolean InHeader = True;
    FILE * ArticleFile;
    FILE * HeaderFile;
    FILE * BodyFile;
    VarBuf LineOfArticle = VBCreate();

    if ( argc != 4 )
    {
        fprintf( stderr, "Usage: SplitArticle ArticleFile HeaderFile BodyFile\n" );
        exit( EXIT_FAILURE );
    }

    if ( ( ArticleFile = fopen( argv[1], "r" ) ) == NULL )
    {
        fprintf( stderr, "Cannot open %s\n", argv[1] );
        exit( EXIT_FAILURE );
    }

    if ( ( HeaderFile = fopen( argv[2], "w" ) ) == NULL )
    {
        fprintf( stderr, "Cannot open %s\n", argv[1] );
        exit( EXIT_FAILURE );
    }

    if ( ( BodyFile = fopen( argv[3], "w" ) ) == NULL )
    {
        fprintf( stderr, "Cannot open %s\n", argv[1] );
        exit( EXIT_FAILURE );
    }

    while ( VBReadLine( LineOfArticle, ArticleFile, WITH_NEWLINE ) )
    {
	if ( InHeader )
	{
	    if ( LineIsBlank( VBAsString( LineOfArticle) ) )
	    {
		InHeader = False;
	    }
	    else
	    {
		fprintf( HeaderFile, "%s", VBAsString(LineOfArticle) );
	    }
	}
	else
	{
	    fprintf( BodyFile, "%s", VBAsString(LineOfArticle) );
	}

	VBReset( LineOfArticle );
    }

    VBDestroy( LineOfArticle );

    return EXIT_SUCCESS;
}
