/*
 * NAME
 *   PostArticle.c
 * USAGE
 *   Usage: PostArticle ArticleFile
 * DESCRIPTION
 *   Post an article to one or more newsgroups.
 * COPYRIGHT
 *   Skim - Off-line news reading package optimized for slow lines.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   Skim version 0.6.
 */

#include <unistd.h>
#include <string.h>

#include "VarBuf.h"

#include "Skim.h"

FILE_ID("/home/rene/sys/CVS_MasterSourceRepository/skim/PostArticle.c,v 1.12 1995/08/15 19:33:36 rpijlman Exp");

int main( int argc, char **argv )
{
    FILE * NewsServer;
    FILE * ArticleFile;
    VarBuf LineOfArticle = VBCreate();

    if ( argc != 2 )
    {
        fprintf( stderr, "%s\n", "Usage: PostArticle ArticleFile" );
        exit( EXIT_FAILURE );
    }

    if ( ( ArticleFile = fopen( argv[1], "r" ) ) == NULL )
    {
        fprintf( stderr, "Cannot open article file '%s'\n", argv[1] );
        exit( EXIT_FAILURE );
    }

    NewsServer = NNTPStreamOpen();

    if ( fprintf( NewsServer, "post\r\n" ) == EOF ||
         fflush( NewsServer ) == EOF )
    {
        fprintf( stderr, "Error writing to NewsServer.\n" );
        exit( EXIT_FAILURE );
    }
    CheckStatusResponse( NewsServer, NULL, "340" );

    while ( VBReadLine( LineOfArticle, ArticleFile, WITHOUT_NEWLINE ) )
    {
	/*
	 * RFC-977 wants us to double a period at the first character of
	 * the line.
	 */
	if ( *VBAsString( LineOfArticle ) == '.' )
	{
	    fprintf( NewsServer, "." );
	}

	if ( fprintf( NewsServer, "%s\r\n", VBAsString(LineOfArticle) ) == EOF )
	{
	    fprintf( stderr, "Error writing to news server\n" );
	    exit( EXIT_FAILURE );
	}

	VBReset( LineOfArticle );
    }

    if ( fprintf( NewsServer, ".\r\n" ) == EOF ||
         fflush( NewsServer ) == EOF ||
         ferror( NewsServer ) )
    {
        fprintf( stderr, "Error writing to NewsServer.\n" );
        exit( EXIT_FAILURE );
    }
    CheckStatusResponse( NewsServer, NULL, "240" );

    NNTPStreamClose( NewsServer );

    VBDestroy( LineOfArticle );

    return EXIT_SUCCESS;
}
