#!/usr/local/bin/wish -f
puts "TK V$tk_version"
source "[info library]/init.tcl"
source "$tk_library/tk.tcl"

if {$nn_x_dir == "."} {
    set nn_x_dir [pwd]
}

lappend auto_path "$nn_x_dir/tcl"
lappend auto_path "$nn_x_dir/tcl/exmh"

set config_windows {.display .prompt .user .groups .folders .post\
	.pref .pref0 .pref1 .pref2 .pref3 .variables .seditpref .compose  .nntpm .nn\
        .var_misc .var_group .var_cascade}

set monochrome 0
if {$tk_version >= 4.0} {
    if {[winfo screendepth .] == 1} {
	set monochrome 1
    }
} else {
    if {[tk colormodel .] == "monochrome"} {
	set monochrome 1
    }
}
if {$monochrome == 1} {
    option add *selectForeground white 99
    option add *selectBackground black 99
    option add *activeForeground white 99
    option add *activeBackground black 99
}


# nn-tk options
#
#set config_var {single_main menu_min menu_max mk_group_menu\
#		    default_article_lines mono_font middle_button_pos\
#		    mime_handling  xterm_path group_list_read group_list_unsub\
##		    group_list_all group_list_width group_menu_read group_menu_unsub\
#		    nntp_progress}
set var_misc {menu_min menu_max default_article_lines mono_font middle_button_pos\
		  mime_handling nntp_progress xterm_path}

set var_group {single_main group_list_read group_list_unsub group_list_all\
		   group_list_width}

set var_cascade {mk_group_menu group_menu_read group_menu_unsub}

set config_var "$var_misc $var_group $var_cascade"

#Note menu_max must be after menu_min

set options_type(menu_max) panel
set options_header(menu_max) "."

set options_type(default_article_lines) int
set options_header(default_article_lines) "Article lines displayed"

set options_type(mono_font) bool
set options_header(mono_font) "Mono space font for articles"

set options_type(middle_button_pos) int
set options_header(middle_button_pos) "Position of middle button row"
set butt(middle_button_pos) {"above menu panel" \
         "betweem menu panel and article panel" "below article panel"}

set options_type(mime_handling) int
set options_header(mime_handling) "Decoding MIME"
set butt(mime_handling) {"No MIME handling" \
	 "Don't handle text/plain as MIME" "Handle all MIME articles"}

set options_type(xterm_path) str
set options_header(xterm_path) "Path for xterm"

set options_type(nntp_progress) int
set options_header(nntp_progress) "NNTP progress every N lines"

#

set options_type(single_main) bool
set options_header(single_main) "Part of main window"

set options_type(group_list_read) bool
set options_header(group_list_read) "Include groups with no unread"

set options_type(group_list_unsub) bool
set options_header(group_list_unsub) "Include unsubscribed groups"

set options_type(group_list_all) bool
set options_header(group_list_all) "Include all articles in number"

set options_type(group_list_width) slider
set options_header(group_list_width) "Width of list"
set options_other(group_list_width) "10 60"

#

set options_type(mk_group_menu) bool
set options_header(mk_group_menu) "Make menus at startup"

set options_type(group_menu_read) bool
set options_header(group_menu_read)  "Include groups with no unread"

set options_type(group_menu_unsub) bool
set options_header(group_menu_unsub) "Include unsubscribed groups"

config_read


#  fix color on main window frame
set color_bl [option get . background Background]
. configure -background $color_bl

# highlight surrounds of article menu
set color_bd [option get . bold {} ]
option add *menu-g*Background  $color_bd
option add *menu-prompt*Background  $color_bd

# color for select
set color_bs [option get . select {} ]
#
# nn variables stuff
#
set butt(auto-select-closed) {"select first" "select unread" "select all"}
set butt(enter-last-read-mode) {"ignore" "enter if unread(confirm)" \
	"enter next unread(conf)" "enter if unread(no conf)" \
	"enter next unread(no conf)"}
set butt(from-line-parsing) {"always" "at least 8 fields" "valid date & time"}
set butt(layout) {"name, subject, lines" "name, lines, subject" \
	"lines, subject" "subject" "usually n, l, s but s only if too long"}
set butt(marked-by-next-group) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(marked-by-read-return) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(marked-by-read-skip) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(print-header-type) {"No header" "Short header" "Full header"}
set butt(menu-spacing) {"no blank line" "between different subjects" \
	"between all aricles"}
set butt(new-group-action) {"ignore not it .newsrc" \
	"add not in .newsrc to start" "add not in .newsrc to end" \
	"add new to .newsrc" "add new to .newsrc(confirm)" \
	"add new to .newsrc( rn format)"}
set butt(re-layout) {"one > per reference(a)" "single > if Re:(b)"\
	"number references N>" "single Re:" "if references (a) else (b)"}
set butt(show-purpose-mode) {"never" "new groups" "all groups"}
set butt(sort-mode) {"arrival" "subject age" "lexical" "age" "sender"}
#
set token(K_INVALID)			\x0000 

set token(K_UNBOUND)			\x0001 

set token(K_REDRAW)			\x0002 
set token(K_CONTINUE)			\x0003 
set token(K_LAST_MESSAGE)		\x0004 
set token(K_HELP)			\x0005 
set token(K_SHELL)			\x0006 
set token(K_VERSION)			\x0007 
set token(K_EXTENDED_CMD)		\x0008 

set token(K_QUIT)			\x0009 
set token(K_BUG_REPORT)			\x000a 

set token(K_SAVE_NO_HEADER)		\x0011 
set token(K_SAVE_SHORT_HEADER)		\x0012 
set token(K_SAVE_FULL_HEADER)		\x0013 

set token(K_PRINT)			\x0014 

set token(K_UNSHAR)			\x0015 

set token(K_REPLY)			\x0016 
set token(K_FOLLOW_UP)			\x0017 
set token(K_POST)			\x0018 
set token(K_MAIL_OR_FORWARD)		\x0019 
set token(K_CANCEL)			\x001a 
set token(K_UNSUBSCRIBE)		\x001b 
set token(K_GROUP_OVERVIEW)		\x001c 
set token(K_PATCH)			\x001d 
set token(K_UUDECODE)			\x001e 

set token(K_GOTO_GROUP)			\x001f 

set token(K_KILL_HANDLING)		\x0020 

    # scrolling/menu movement */

set token(K_CONTINUE_NO_MARK)		\x0021 
set token(K_JUNK_ARTICLES)		\x0022 
set token(K_SKIP_LINES)			\x0023 
set token(K_NEXT_PAGE)			\x0024 
set token(K_NEXT_HALF_PAGE)		\x0025 
set token(K_NEXT_LINE)			\x0026 
set token(K_PREV_PAGE)			\x0027 
set token(K_PREV_HALF_PAGE)		\x0028 
set token(K_PREV_LINE)			\x0029 

set token(K_HEADER_PAGE)		\x002a 
set token(K_FIRST_PAGE)			\x002b 
set token(K_LAST_PAGE)			\x002c 

set token(K_GOTO_LINE)			\x002d 
set token(K_GOTO_PAGE)			\x002e 
set token(K_GOTO_MATCH)			\x002f 
set token(K_NEXT_MATCH)			\x0030 

set token(K_PREVIOUS)			\x0031 

    # more() SPECIFIC COMMANDS */

set token(K_LEAVE_ARTICLE)		\x0032 
set token(K_LEAVE_NEXT)			\x0033 
set token(K_NEXT_ARTICLE)		\x0034 
set token(K_NEXT_SUBJECT)		\x0035 
set token(K_FULL_DIGEST)		\x0036 
set token(K_ROT13)			\x0037 
set token(K_COMPRESS)			\x0038 
set token(K_BACK_TO_MENU)		\x0039 
set token(K_BACK_ARTICLE)		\x003a 
set token(K_FORW_ARTICLE)		\x003b 
set token(K_WWW)		        \x003c 

    # menu() SPECIFIC COMMANDS	 */

set token(K_SELECT)			\x0041 
set token(K_SELECT_INVERT)		\x0042 
set token(K_SELECT_SUBJECT)		\x0043 
set token(K_SELECT_RANGE)		\x0044 
set token(K_AUTO_SELECT)		\x0045 
set token(K_UNSELECT_ALL)		\x0046 

set token(K_SEL_GROUP)			\x0047 

set token(K_LAYOUT)			\x0049 

set token(K_NEXT_GROUP_NO_UPDATE)	\x004a 
set token(K_READ_GROUP_UPDATE)		\x004b 
set token(K_READ_GROUP_THEN_SAME)	\x004c 

set token(K_ADVANCE_GROUP)     		\x004d 
set token(K_BACK_GROUP)			\x004e 

set token(K_PREVIEW)			\x004f 

set token(K_OPEN_SUBJECT)		\x0050 
set token(K_CLOSE_SUBJECT)		\x0051 

set token(K_M_TOGGLE)			\x0060 
set token(K_M_CONTINUE)			\x0061 
set token(K_M_SELECT)			\x0062 
set token(K_M_SELECT_SUBJECT)		\x0063 
set token(K_M_SELECT_RANGE)		\x0064 
set token(K_M_PREVIEW)			\x0065 
set token(K_S_EXTENDED_CMD)		\x0066 

set token(K_EQUAL_KEY)			\x0070 

set token(K_MACRO)			\x0100 
set token(K_ARTICLE_ID)			\x0200 
set token(K_PREFIX_KEY)			\x0400 

set EV_CHAR	1
set EV_FUNCT	2
set EV_SELECT	3
set EV_RETURN	4
set EV_SELECT_C 5
set EV_INT	6

proc set_option_values {} {
    global Config
    option_values $Config(menu_max) $Config(menu_min) $Config(mk_group_menu) \
	$Config(default_article_lines) $Config(mime_handling) \
	$Config(xterm_path) $Config(group_list_read)  $Config(group_list_unsub)\
	$Config(group_list_all) $Config(group_list_width) $Config(group_menu_read) \
	$Config(group_menu_unsub) $Config(nntp_progress)
}

#              execute nn function
proc put_funct {ch {type .}} {
	global ev_input ev_type EV_FUNCT
	if {$type == "m"} {
		ev_type_menu
	} 
	rec_c $EV_FUNCT $ch
#	puts stderr "<$ch>"
}

#              execute extended function
proc put_extended {cmd {type .}} {
	global token ev_param
	set ev_param $cmd
	 put_funct $token(K_S_EXTENDED_CMD) $type
}

#              replace text
proc text_ent {scr} {
	global text_ent_t

	$scr delete 1.0 "1.0 lineend"
	$scr insert 1.0 $text_ent_t
}

#              add string to text
proc text_add {scr} {
	global text_ent_t

	$scr insert end $text_ent_t

}

#              delete character from end of text
proc text_delc {scr} {

	$scr delete "end -1 chars"
}

#              if not in group menu return to it
proc ev_type_menu {} {
	global menu_mode read_mode token EV_INT EV_FUNCT
	if {$read_mode != "c"} {
		rec_c $EV_INT 0
	}
	if {$menu_mode != "m"} {
		rec_c $EV_FUNCT $token(K_BACK_TO_MENU)
	}
}

#		handle key input	
proc put_key {k} {
    global ev_input ev_type EV_CHAR
	if {"$k" != ""} {
    		rec_c $EV_CHAR $k
	}
}

proc put_del {} {
    global EV_CHAR
    rec_c $EV_CHAR "\x8f"
}

proc put_bs {} {
    global EV_CHAR
    rec_c $EV_CHAR "\b"
}

proc put_ret {} {
    global EV_CHAR
    rec_c $EV_CHAR "\r"
}

proc button_mode {butt val} {
    $butt configure -state $val
}


# Handle destroy
#
proc exit_nn {w} {
    if {$w == "."} {
	application_destroyed
    }
}

proc text_bindings {txt} {
    global tk_version has_exmh sedit

    bind $txt <Enter> "focus %W"
    if {$tk_version >= 4.0} {
	bind $txt <Any-KeyPress> "put_key %A; break"
	bind $txt <Key-Delete>  "put_del; break"
	bind $txt <Key-BackSpace>  "put_bs; break"
	bind $txt <Key-Return>  "put_ret; break"
	bindtags $txt "$txt Text . all"
    } else {
	bind $txt <Any-KeyPress> "put_key %A"
	bind $txt <Key-Delete>  "put_key %A"
	bind $txt <Key-BackSpace>  "put_key %A"
	bind $txt <Key-Return>  "put_key %A"
	bind $txt <Control-1> {%W scan mark %y}
	bind $txt <Control-B1-Motion> {%W scan dragto %y}
    }
}

proc setup_bindings {} {
    global tk_version has_exmh sedit

    if {$tk_version < 4.0} {
	bind Entry <Control-1> {%W scan mark %x}
	bind Entry <Control-B1-Motion> {%W scan dragto %x}

	bind Text <Control-B1-Motion> {%W scan dragto %y}

	if {!$has_exmh} {
	    bind Entry <Button-2> {catch {%W insert insert [selection get];\
					      tk_entrySeeCaret %W}}
	} else {
	    case $sedit(scrollButton) {
		Right {
		    bind .more.t <B3-Motion> {%W scan dragto %y}
		    bind Listbox <B3-Motion> {%W scan dragto %x %y}
		}
		Middle {
		    bind .more.t <B2-Motion> {%W scan dragto %y}
		    bind Listbox <B2-Motion> {%W scan dragto %x %y}
		}
		ShiftMiddle {
		    bind .more.t <Shift-B2-Motion> {%W scan dragto %y}
		    bind Listbox <Shift-B2-Motion> {%W scan dragto %x %y}
		}
		None {}
	    }
	}
    } else {
	tkEntryBind Enter
	tkTextBind Enter
	tkListboxBind Enter
    }

    bind Entry <Enter> "focus %W"
}

proc fetch_nn_variables {} {
    global print

    set print(cmd) "cat \$file | [nn_get_var printer]"
}

proc list_bindings {} {
    global tk_version

    if {$tk_version < 4.0} {
	bind Listbox <Control-1> {%W scan mark %x %y}
	bind Listbox <Enter> "focus %W"
    }
    bind Listbox <Any-KeyPress> "put_key %A"
    bind Listbox <Key-Delete>  "put_del"
    bind Listbox <Key-BackSpace>  "put_bs"
    bind Listbox <Key-Return>  "put_ret"
}

#
#	Main routine
#

set chp 0
set s_last 0
set list_cnt 0
set tcl_interactive 1
set grp_x 300
set grp_y 300

set read_mode " "
set menu_mode "m"

if [file exists $nn_x_dir/tcl/exmh] {
    set has_exmh 1
} else {
    set has_exmh 0
}

list_bindings

set_option_values

if {$has_exmh} {
    source "$nn_x_dir/tcl/exmh/main.tcl"
    source "$nn_x_dir/tcl/exmh/exwin.tcl"
    source "$nn_x_dir/tcl/exmh/preferences.tcl"
    source "$nn_x_dir/tcl/exmh/seditBind.tcl"
    catch {
	source "$nn_x_dir/tcl/exmh/pgpMisc.tcl"
    }

    catch {
	source "$nn_x_dir/tcl/exmh/msgShow.tcl"
    }

    exmh_init
} 

prompt_Make
main_Make
list_mk .groups 

setup_bindings

wm title . "News"
wm iconname . "News"

wm geometry . $Config(.nn)

if {$tk_version >= 4.0} {
    update
    pack propagate . no
}

bind . <Destroy> "exit_nn %W"

menu_resize $Config(menu_max)






