proc Exmh_Focus {} {
}

proc Label_Message { text } {
}

proc Msg_Redisplay { draft } {
}

proc nn_send {draft t} {
    global aux_dir aux_prog aux_POST sedit aux_MAILER msg

    set id [SeditId $draft]

    set msg(path) "$aux_dir/$draft"

    if {$sedit(autoSign) && ($sedit($t,sigfile) != "") && 
	![info exists exmh($id,mhannodist)]} {
	set b .sedit${id}.but
	eval [option get $b.sign command {}] $sedit($t,sigfile)
    }

    SeditSave "$draft" $t
#    SeditSave "$aux_dir/$draft" $t
    if {$sedit($t,8bit)} {
	# Turn on automatic quoting if we've entered 8-bit characters.
	if {$sedit($t,quote) < 0} {
	    set sedit($t,quote) 1
	}
    }
    if {$sedit($t,quote) > 0} {
	SeditSendQuotePrintable $draft $t
    }

    if {[info commands Misc_PostProcess] != ""} {
#      exmh 1.6
	set in [open "$draft"  r]
	set mailheader [Misc_GetHeader $in]
	close $in

	# call the pgp postprocesing if necessary
	set hdrIndex [lsearch -glob $mailheader "pgp-action:*"]
	if {($hdrIndex >= 0) &&
            ![regexp -nocase {^[^ ]*: *none} [lindex $mailheader $hdrIndex]]} {
	    Pgp_Process "$draft" "$draft"
	}
    } else {
	Pgp_Process "$draft"
    }

    if {$aux_prog == "post" || $aux_prog == "follow"} {
	eval "exec $aux_POST $draft"
    } elseif {$aux_prog == "mail" || $aux_prog == "reply" \
	    || $aux_prog == "forward"} {
	eval "exec $aux_MAILER <$draft"
    }
    if {!$sedit($t,keep)} {
	SeditQuit "$draft" $t
    }
}


proc ExwinFixupFtextLines { args } {
    puts ExwinFixupFtextLines 
}


proc nn_PreferencesSave {} {
    global nn_x_dir
# need .pref to stop PreferencesDismiss aborting
    if {![winfo exists .pref]}  {
	toplevel .pref
	wm withdraw .pref} 
    PreferencesSave
    catch {destroy .pref}
    if [catch {option readfile "$nn_x_dir/tcl/nn-defaults" startup} err] {
	tkerror "nn-defaults error: $err"
    }
}

proc SeditReadPref {} {
    global sedit
    set sedit(key,selpaste) {<Control-y> <Button-2>}
    set sedit(scrollButton) ShiftMiddle

    if [file exists $sedit(dotfile)] {
	if [catch {uplevel #0 source [glob $sedit(dotfile)]} msg] {
	    Exmh_Status "Error in $sedit(dotfile): $msg"
	    return
	} 
    }
}

proc exmh_init {} {
    global nn_directory  nn_x_dir
    global mime widgetText exmh msg mhProfile
    global widgetText env pref sedit pgp exwin mailcap_default

    if {! [info exists env(USER)]} {
	set env(USER) dummy
    }

    if [catch {tk colormodel .}] {
        rename tk tk-orig
        proc tk { option args } {
            switch -- $option {
                colormodel {
                    if {[winfo depth $args] > 4} {
                        return color
                    } else {
                        return monochrome
                    }
                }
                default {
                    return [eval {tk-orig $option} $args]
                }
            }
        }
    }

#    catch {
	ExmhResources
#    }

    if [info exists env(MH)] {
        set mhProfile(profile) $env(MH)
    } else {
        set mhProfile(profile) $env(HOME)/.mh_profile
    }

    set mailcap_default /etc/mailcap
    set exwin(ftextLines) 1
    
    set mime(dir) /usr/local/bin
    set pgp(path) /usr/local/bin

    set exmh(version) nn-tk.9
    set exmh(library) $nn_x_dir/tcl/exmh
    set exmh(folder)  $nn_directory
    set exmh(userLibrary)  $nn_directory

    set mhProfile(draft-folder) .
    set mhProfile(header-suppress) {}
    set mhProfile(header-display) {}

    set msg(id) 1
    set sedit(sigfileDefault) .signature

    set pref(uid) 0
    set pref(panes) {}
    set pref(helpInOneWindow) 1

    set pref(appDefaults) $nn_x_dir/tcl/exmh/app-defaults
    set pref(userDefaults) $nn_directory/tk-config

    set pref(localDefaults) $pref(appDefaults).local

    PreferencesReadFile $nn_x_dir/tcl/exmh/app-defaults startup

    Preferences_Resource msg(tagnames) m_tagnames general

    Sedit_Init
    Mime_Init
    Fdisp_Init
    catch {
	Pgp_Init
    }
    catch {
	fileselect_Init
    }
    Widget_TextInit
    Exwin_Init
    Busy_Init
    Sedit_BindInit
    catch {
	TextButton_Init
    }
    catch {
	URI_Init
    }

    Mh_Preferences
#    puts $pref(panes)
    if {[info exists pref(WWW,text)]} {
	set pref(panes) {"Simple Editor" MIME  "WWW" "FS Box"}
    } else {
	set pref(panes) {"Simple Editor" MIME  "URI" "FS Box"}
    }
    set addpgp 1
    catch {
#      in case pgp(enabled) not defined
	if {!$pgp(enabled)} {
	set addpgp 0
	}
    }
    if {$addpgp} {
	append pref(panes) { "PGP interface"}
    }
}

proc start_mime {t} {
    .more.t configure -wrap word
    MsgShowInText .more.t $t
}

proc clear_mime {} {
    Mime_Cleanup .more.t
    .more.t configure -state normal
    more_tags
    .more.t configure -wrap none
}

proc do_send {prog tmp} {
    global  aux_WORK sedit
    global aux_dir aux_prog
    upvar mhProfile mhProfile

    set aux_prog $prog
puts "aaux=$aux_WORK"
    set n [string last "/" $aux_WORK]
    set aux_dir [string range $aux_WORK 0 [expr $n-1]]
    set t_file  [string range $aux_WORK  [expr $n+1] end]
    set mhProfile(path) $aux_dir

    set cur_dir [pwd]
    cd $aux_dir

    if {$aux_prog == "post" || $aux_prog == "follow"} {
	set sn [nn_get_var append-signature-post]
    } elseif {$aux_prog == "mail" || $aux_prog == "reply" || $aux_prog == "forward" } {
	set sn [nn_get_var append-signature-mail]	
    }
    if {$sn == "on"} {
	set sedit(autoSign) 1
    } else {
	set sedit(autoSign) 0
    }

    Sedit_Start $aux_WORK
#    Sedit_Start $t_file
    cd $cur_dir
}

