#ifndef _MISC_H_
#define _MISC_H

struct ex_list  {
	int ex_pty;			/* Do we want a pty? */
	int ex_addr;			/* The last byte of the address */
	int ex_fport;                   /* Port to telnet to */
	char *ex_exec;                  /* Command line of what to exec */
	struct ex_list *ex_next;
};

extern struct ex_list *exec_list;
extern u_int curtime, time_fasttimo, last_slowtimo, lastime;
extern int tmp_time;
extern u_char idle_frame_end;
extern int idle_time, idle_sec;

int redir_x _P((int, char *, u_int32_t));
void getouraddr _P((void));
void config _P((char *));
int do_config _P((char *, struct socket *, int));
void updtime _P((void));
int fork_exec _P((struct socket *, char *, int));
int add_exec _P((struct ex_list **, int, char *, int, int));
int remove_exec _P((struct ex_list **, int, char *, int));

#ifndef HAVE_STRDUP
char *strdup _P((char *));
#endif

void do_wait _P((int));

#endif
