#!/bin/sh
#
# PP start/stop script
# Usage: pp [ start | stop ]
#

action=$1

. /etc/init.d/LIB

killall=`pathof killall /bin:/usr/bin`

PROCS="pptsapd qmgr"


case "$action" in
	start)
		for p in $PROCS
		do
			if $killall -0 $p 2> /dev/null; then
				: already running
			else
				it=`pathof $p /usr/lib/pp/cmds:/usr/pp/cmds`
				if [ -n "$it" ]; then
					if [ -z "$started" ]; then
						echo $use_escapes "Starting PP services: \c"
						started=yes
					fi
					su mail -c $it > /dev/null 2>&1
					echo $use_escapes " $p\c"
				fi
			fi
		done
		if [ -n "$started" ]; then
			echo " ... done"
		fi
		;;

	stop)
		# Kill the service daemons
		wipeout $PROCS
		echo "PP services stopped"
		;;

	*)
		echo "usage: pp start|stop"
		exit 1
		;;
esac
