/* Copyright (C) 1995 -- Joel Katz -- Stimpson@panix.com */
/* All rights reserved except as specified in included   */
/* file "main.c".					 */

#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>

/* At this point we know we are dealing with a dummy account, and we have */
/* been chdir'ed to the dummyfinger directory. If no file corresponding to */
/* the username exists, we return an error. If a file exists, we pass it to */
/* the caller. If there is a subdirectory, we call the file with the name */
/* of the subnam. If there is a subdirectory and we have no subnam, we */
/* output /home/finger/usnam/usnam */

/* Uncomment the line below if you are afraid someone will tamper with */
/* the files in /home/finger or you don't trust someone who has root   */
/* access (that would be really weird). More realistically, uncomment  */
/* The line below if you are afraid unwanted executables will somehow  */
/* get into /home/finger or its subdirectories.                        */

/* #define NO_DUMMY_PROGRAMS */

/* Define NOSUCHUSERPATH and NOSUCHUSERFNM to enable custom handling */
/* of fingers of unknown users. Create a file called /etc/badfinger that */
/* is world executable. It takes one parameter which is the user fingered. */

/* #define NOSUCHUSERPATH "/etc/"     */
/* #define NOSUCHUSERFNM  "badfinger" */

extern void call_program(char *filename, char *p1, char *p2, char *p3);
extern char orighost[], origip[];
extern struct passwd *pw;

void error(char *usnam)
{
#ifdef NOSUCHUSERPATH
#ifdef NOSUCHUSERFNM
 execl(NOSUCHUSERPATH NOSUCHUSERFNM, NOSUCHUSERFNM, usnam, NULL);
#endif
#endif
 printf("finger: %s: no such user\n",usnam);
 exit(0);
}

void blit(char *un, char *fnm)
{
 char buf[256];
 FILE *j;
 int i,k;
 i=open(fnm,O_RDONLY);
 if(i<0) error(un);
 while((k=read(i,buf,256))!=0)
  fwrite(buf,k,1,stdout);
 close(i);
}

void dummyfinger(char *usnam, char *subnam)
{
 struct stat s;
 int i;
 pw=getpwnam("root"); /* Use root's shell */
 if(pw==NULL) /* Wouldn't that be odd? */
 { 
  pw=(struct passwd *) malloc(sizeof(struct passwd));
  pw->pw_shell=(char *) malloc(12);
  strcpy(pw->pw_shell,"/bin/sh");
 }
 i=stat(usnam,&s);
 if(i!=0) error(usnam); /* Dummy name does not exist */
 if(S_ISDIR(s.st_mode))
 {
  if(chdir(usnam)) error(usnam); /* If it's a dir, we go into it */
  i=stat(subnam,&s); /* And try to stat the subname */
  if(i==0) 
  { /* valid subname */
#ifndef NO_DUMMY_PROGRAMS
   if((S_IXOTH|S_IXUSR|S_IXGRP)&s.st_mode) 
   { 
    call_program(subnam,&orighost[0],&origip[0],
      subnam[0]==0 ? NULL : &subnam[0]); 
    return; 
   }
#endif
   blit(usnam,subnam); 
   return; 
  }
  i=stat(usnam,&s);
  if(i==0)
  {
#ifndef NO_DUMMY_PROGRAMS
   if((S_IXOTH|S_IXUSR|S_IXGRP)&s.st_mode) 
   { 
    call_program(usnam,&orighost[0],&origip[0],
     subnam[0]==0 ? NULL : &subnam[0]); 
    return; 
   }
#endif
   blit(usnam,usnam);
   return;
  }
  error(usnam);
 }
 else /* dummy is file, not dir */
 {
#ifndef NO_DUMMY_PROGRAMS
  if((S_IXOTH|S_IXUSR|S_IXGRP)&s.st_mode) 
  { 
   call_program(usnam,orighost,origip,
    subnam[0]==0 ? NULL : &subnam[0]); 
   return; 
  }
#endif
  blit(usnam,usnam);
 }
}
