/*
 * STRMCPY routine by Thomas McWilliams
 */

#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#ifndef PROGRAM_SYSLOG
#define PROGRAM_SYSLOG	1
#endif

void strmcpy(char **t, const char *s)
{
    if (*t != NULL)
	free(*t);

    *t = malloc(strlen(s) + 1);

    if (*t == NULL) {
#ifdef	SYSLOG
	syslog(LOG_ERR, "strmcpy: malloc error");
#endif
	exit(PROGRAM_SYSLOG);
    }

    (void) strcpy(*t, s);
}
