#!/usr/bin/perl
#
# Program to check for the nobody user and group
# for CFINGERD Distribution
#
# Released under the GPL as part of the Security/Administrative Package.
# Please read "README" for more details.
#
# WRITTEN IN Perl.  So I like Perl.  So shoot me.  :-)

sub check_groups {
    $NOBODY_UID = "";
    $NOBODY_GID = "";
    open(INFILE, "/etc/passwd") || die "/etc/passwd: $!\n";
    while(<INFILE>) {
	chop;
	($uname, $pw, $uid, $gid, $gecos, $dir, $shell) = split(/:/);
	if ($uname eq "nobody") {
	    $NOBODY_UID = "-DNOBODY_UID=${uid}";
	    $NOBODY_GID = "-DNOBODY_GID=${gid}";
	    $NUID = $uid;
	    $NGID = $gid;
	}
    }

    if ($NOBODY_UID ne "") {
	print "You have a nobody userid.  Good.\n";
    } else {
	print "Whoops, you don't have a \"nobody\" user on your system.\n";
	print "Using \"old-faithful\"...\n\n";
	$NOBODY_UID = "-DNOBODY_UID=32767";
	$NOBODY_GID = "-DNOBODY_GID=32766";
	$NUID = 32767;
	$NGID = 32766;
    }
}

1;
