/* Cmdlist.c */

#include "Sys.h"
#include "Curses.h"

#include "Util.h"
#include "Main.h"
#include "Open.h"
#include "Cmds.h"
#include "Glob.h"
#include "List.h"
#include "Find.h"
#include "Get.h"
#include "Put.h"
#include "Hostwin.h"
#include "Prefs.h"
#include "Cmdline.h"

/* The command list.  I suppose they don't really need to be in alphabetical
 * order, but some order is better than total chaos.
 */
Command gCommands[] = {
	{ "?",
		kCmdHidden,
		HelpCmd,
		kNoMin, kNoMax,
		"[optional commands]",
		"shows commands, or detailed help on specified commands"
	},
	{ "!",
		0,
		ShellCmd,
		kNoMin, kNoMax,
		"[command]",
		"Executes specified command, or if none given, runs a shell"
	},
	{ "ascii",
		kCmdMustBeConnected | kCmdHidden,
		TypeCmd,
		0, 0,
		"",
		"sets the file transfer type to ASCII text"
	},
	{ "binary",
		kCmdMustBeConnected | kCmdHidden,
		TypeCmd,
		0, 0,
		"",
		"sets the file transfer type to binary/image"
	},
	{ "bye",
		kCmdHidden,
		QuitCmd,
		0, 0,
		"",
		"exits NcFTP"
	},
	{ "cd",
		kCmdMustBeConnected,
		ChdirCmd,
		1, 1,
		"<directory>",
		"changes remote working directory"
	},
	{ "close",
		kCmdMustBeConnected,
		CloseCmd,
		0, 0,
		"",
		"closes the connection to the remote host"
	},
	{ "create",
		kCmdMustBeConnected,
		CreateCmd,
		1, 1,
		"empty-file-name",
		"creates an empty file on the remote host"
	},
	{ "debug",
		0,
		DebugCmd,
		kNoMin, kNoMax,
		"[debug level]",
		"sets debug mode to level x"
	},
	{ "delete",
		kCmdMustBeConnected | kCmdHidden,
		DeleteCmd,
		1, kNoMax,
		"file1 [file2...]",
		"deletes files from the remote host"
	},
	{ "dir",
		kCmdMustBeConnected,
		ListCmd,
		kNoMin, kNoMax,
		"[items to list]",
		"prints a verbose directory listing"
	},
	{ "echo",
		0,
		EchoCmd,
		kNoMin, kNoMax,
		"[items to echo]",
		"echos back to screen, expanding special % and @ sequences"
	},
	{ "exit",
		kCmdHidden,
		QuitCmd,
		0, 0,
		"",
		"quits NcFTP"
	},
	{ "find",
		kCmdMustBeConnected | kCmdHidden,
		FindCmd,
		1, 1,
		"pattern",
		"searches the remote server for filenames containing the pattern"
	},
	{ "get",
		kCmdMustBeConnected,
		GetCmd,
		1, kNoMax,
"[-flags] file1 [file2...]\n\
Flags:\n\
  -C   : Force continuation (reget).\n\
  -f   : Force overwrite.\n\
  -G   : Don't use wildcard matching.\n\
  -R   : Recursive.  Useful for fetching whole directories.\n\
  -n X : Get selected files only if X days old or newer.\n\
  -z   : Get the remote file X, and name it to Y.\n\
Examples:\n\
  get README\n\
  get README.*\n\
  get -G **Name.with.stars.in.it**\n\
  get -R new-files-directory\n\
  get -z WIN.INI ~/junk/windows-init-file\n",
		"fetches files from the remote host"
	},
	{ "help",
		0,
		HelpCmd,
		kNoMin, kNoMax,
		"[optional commands]",
		"shows commands, or detailed help on specified commands"
	},
	{ "hosts",
		kCmdMustBeDisconnected,
		HostsCmd,
		kNoMin, kNoMax,
		"",
		"lets you edit the settings for each remote host"
	},
	{ "lcd",
		0,
		LocalChdirCmd,
		kNoMin, 1,
		"<directory>",
		"changes local working directory"
	},
	{ "lls",
		0,
		LocalListCmd,
		kNoMin, kNoMax,
		"[items to list]",
		"prints a local directory listing"
	},
	{ "lookup",
		0,
		LookupCmd,
		1, kNoMax,
		"<host or IP number> [<more hosts or IP numbers>]",
		"looks up information in the host database"
	},
	{ "lpage",
		0,
		LocalPageCmd,
		1, kNoMax,
		"[-b | -p] localFiles...",
		"views a local file with your pager (-p) or built-in pager (-b)"
	},
	{ "lpwd",
		0,
		LocalPwdCmd,
		0, 0,
		"",
		"Prints the current local working directory"
	},
	{ "ls",
		kCmdMustBeConnected,
		ListCmd,
		kNoMin, kNoMax,
		"[items to list]",
		"prints a remote directory listing"
	},
	{ "mget",
		kCmdMustBeConnected | kCmdHidden,
		GetCmd,
		1, kNoMax,
		"file1 [file2...]\n",
		"fetches files from the remote host"
	},
	{ "mkdir",
		kCmdMustBeConnected,
		MkdirCmd,
		1, kNoMax,
		"dir1 [dir2...]",
		"creates directories on the remote host"
	},
	{ "more",
		kCmdMustBeConnected | kCmdNoRedirect | kCmdHidden,
		PageCmd,
		1, kNoMax,
		"file1 [file2...]",
		"views a file from the remote host one page at a time."
	},
	{ "mput",
		kCmdMustBeConnected,
		PutCmd,
		1, kNoMax,
		"file1 [file2...]\n",
		"sends files to the remote host"
	},
	{ "open",
		0,
		OpenCmd,
		kNoMin, kNoMax,
"[-flags] [sitename]\n\
Flags:\n\
  -a   : Open anonymously.\n\
  -u   : Open with username and password prompt.\n\
  -p X : Use port number X when opening.\n\
  -r   : Redial until connected.\n\
  -d X : Redial, delaying X seconds between tries.\n\
  -g X : Give up after X redials without connection.\n\
Examples:\n\
  open sphygmomanometer.unl.edu\n\
  open -u bowser.nintendo.co.jp\n\
  open -r -d 75 -g 10 sphygmomanometer.unl.edu\n",
		"connects to a remote host"
	},
	{ "page",
		kCmdMustBeConnected | kCmdNoRedirect,
		PageCmd,
		1, kNoMax,
		"file1 [file2...]",
		"views a file from the remote host one page at a time."
	},
	{ "pdir",
		kCmdMustBeConnected | kCmdNoRedirect,
		ListCmd,
		kNoMin, kNoMax,
		"[items to list]",
		"views a directory listing through your pager"
	},
	{ "pls",
		kCmdMustBeConnected | kCmdNoRedirect,
		ListCmd,
		kNoMin, kNoMax,
		"[items to list]",
		"views a directory listing through your pager"
	},
	{ "predir",
		kCmdMustBeConnected | kCmdNoRedirect,
		RedirCmd,
		kNoMin, kNoMax,
		"",
		"re-displays the last directory listing through your pager"
	},
#ifdef USE_CURSES
	{ "prefs",
		0,
		PrefsCmd,
		0, 0,
		"",
		"lets you configure the program's settings"
	},
#endif	/* CURSES */
	{ "put",
		kCmdMustBeConnected,
		PutCmd,
		1, kNoMax,
"[-flags] file1 [file2...]\n\
Flags:\n\
  -z   : Send the local file X, and name the remote copy to Y.\n\
Examples:\n\
  put README\n\
  put -z ~/junk/windows-init-file WIN.INI\n",
		"sends a file to the remote host"
	},
	{ "pwd",
		kCmdMustBeConnected,
		PwdCmd,
		0, 0,
		"",
		"Prints the current remote working directory"
	},
	{ "redir",
		kCmdMustBeConnected,
		RedirCmd,
		kNoMin, kNoMax,
		"",
		"re-displays the last directory listing"
	},
	{ "rename",
		kCmdMustBeConnected,
		RenameCmd,
		2, 2,
		"oldname newname",
		"changes the name of a file on the remote host"
	},
	{ "rglob",
		kCmdMustBeConnected | kCmdHidden,
		RGlobCmd,
		1, kNoMax,
		"regex",
		"tests remote filename wildcard matching"
	},
	{ "q",
		kCmdHidden,
		QuitCmd,
		0, 0,
		"",
		"quits NcFTP"
	},
	{ "quit",
		0,
		QuitCmd,
		0, 0,
		"",
		"take a wild guess"
	},
	{ "quote",
		kCmdMustBeConnected,
		QuoteCmd,
		1, kNoMax,
		"command-string",
		"sends an FTP command to the remote server"
	},
	{ "rhelp",
		kCmdMustBeConnected,
		RmtHelpCmd,
		kNoMin, kNoMax,
		"[help string]",
		"requests help from the remote server"
	},
	{ "rm",
		kCmdMustBeConnected,
		DeleteCmd,
		1, kNoMax,
		"file1 [file2...]",
		"deletes files from the remote host"
	},
	{ "rmdir",
		kCmdMustBeConnected,
		RmdirCmd,
		1, kNoMax,
		"dir1 [dir2...]",
		"deletes directories from the remote host"
	},
	{ "set",
		0,
		SetCmd,
		0, 2,
		"[option [newvalue]] | all | help",
		"lets you configure a program setting from the command line"
	},
	{ "site",
		kCmdMustBeConnected,
		QuoteCmd,
		1, kNoMax,
		"command-string",
		"sends a host-specific FTP command to the remote server"
	},
	{ "type",
		kCmdMustBeConnected,
		TypeCmd,
		1, 1,
		"ascii | binary | image",
		"sets file transfer type (one of 'ascii' or 'binary')"
	},
	{ "verbose",
		kCmdHidden,
		VerboseCmd,
		kNoMin, 1,
		"[verbosity level]",
		"sets verbosity mode to 0, 1, 2, or 3"
	},
	{ "version",
		0,
		VersionCmd,
		kNoMin, kNoMax,
		"",
		"prints version information"
	},
};

int gNumCommands = ((int) (sizeof(gCommands) / sizeof(Command)));

/* eof */
