
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	pvmalloc.c
 *
 *	Malloc filter interface.
 *
$Log: pvmalloc.c,v $
 * Revision 1.2  1994/06/03  20:38:21  manchek
 * version 3.3.0
 *
 * Revision 1.1  1993/08/30  23:26:50  manchek
 * Initial revision
 *
 */

/*
#include <malloc.h>
*/
#include "protoglarp.h"
#include "pvmalloc.h"

char *i_malloc(), *i_realloc();

/***************
 **  Private  **
 **           **
 ***************/

static char rcsid[] = "$Id: pvmalloc.c,v 1.2 1994/06/03 20:38:21 manchek Exp $";
static char pvmtxt[512];		/* scratch for error log */


/*****************
 **  Interface  **
 **             **
 *****************/

char *
pvm_alloc(n, tag)
	unsigned n;
	char *tag;
{
	char *r;

	if (!(r = i_malloc(n, tag))) {
		sprintf(pvmtxt, "pvm_alloc: can't get %d bytes", n);
		pvmlogerror(pvmtxt);
	}
	return r;
}


char *
pvm_realloc(p, n)
	char *p;
	unsigned n;
{
	char *r;

	if (!(r = i_realloc(p, n))) {
		sprintf(pvmtxt, "pvm_realloc: can't get %d bytes", n);
		pvmlogerror(pvmtxt);
	}
	return r;
}


void
pvm_free(p)
	char *p;
{
	(void)i_free(p);
}

