/*
	print the status of the group server
*/

#include <stdio.h>
/* #include <malloc.h>   XXX  - yacks on NeXT */
#include "pvmgdef.h"
#include "pvmgs.h"
#include "pvm3.h"
#include "../src/pvmalloc.h"
#define NEWMEMGNAME(length,mxlen,gname) { if ( (length) > (mxlen) )         \
                    {                                                       \
                      if (gname != (char *) NULL)                           \
                         PVM_FREE(gname);                                   \
                      gname=(char *)PVM_ALLOC( sizeof(char) *(length + 1), "pvmgs");\
                      mxlen = length;                                       \
                    }                                                       \
         }

int
main(argc, argv)
int argc;
char *argv[];
{
	int mytid, gstid;
	int i, j, ng; 
        int mxupklen = 0;
	struct group_struct g;
        g.name = (char *) 0;
	mytid = pvm_mytid();
	if((gstid = gs_getgstid()) < 0) {
		fprintf(stderr, "%s: no groups server\n", argv[0]);
		return(-1);
		}
	pvm_initsend(PvmDataDefault);
	pvm_send(gstid, GSLS);
	pvm_recv(gstid, GSLS);
	/* get the number of groups */
	pvm_upkint(&ng, 1, 1);
	if (ng == 0)
		fprintf(stdout, "no groups exist\n");
	for (i = 0; i < ng; i++) {
                pvm_upkint(&g.len,1,1);
                NEWMEMGNAME(g.len+ 1,mxupklen,g.name);
		pvm_upkstr(g.name);
		pvm_upkint(&g.ntids, 1, 1);
		pvm_upkint(&g.barrier_count, 1, 1);
		pvm_upkint(&g.barrier_reached, 1, 1);
		pvm_upkint(g.tids, MAXGTIDS, 1);
		pvm_upkint(g.btids, g.barrier_reached, 1);
		fprintf(stdout, 
			"group: %s, size: %d,  barrier_count %d, barrier_reached %d\n",
			g.name, g.ntids, g.barrier_count, 
			g.barrier_reached);
		fputs("tids:\n", stdout);
		for (j = 0; j < MAXGTIDS; j++)
			if (g.tids[j] > 0)
				fprintf(stdout, "%d 0x%x\t", j, g.tids[j]);
		fputs("\n", stdout);
		if (g.barrier_reached > 0) {
			fputs("tids waiting on barrier:\n", stdout);
			for (j = 0; j < g.barrier_reached; j++)
				fprintf(stdout, "0x%x\t", g.btids[j]);
			fputs("\n", stdout);
			}
		}

	pvm_exit();
}
