
/*
*	timing_slave.c
*
*	See timing.c
*/

#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include "pvm3.h"

#define ENCODING  PvmDataRaw

main(argc, argv)
	int argc;
	char **argv;
{
	int mytid;   /* my task id */
	int dtid;    /* driver task */
	int bufid;
	int n = 0;

	/* enroll in pvm */

	mytid = pvm_mytid();

    /* tell parent I am ready */

    pvm_setopt(PvmRoute, PvmRouteDirect);
    pvm_initsend(ENCODING);
    pvm_send( pvm_parent(), 0 );

	/* pack mytid in buffer */

	pvm_initsend(ENCODING);
	pvm_pkint(&mytid, 1, 1);

	/* our job is just to echo back to the sender when we get a message */

	while (1) {
		bufid = pvm_recv(-1, -1);
		pvm_bufinfo(bufid, (int*)0, (int*)0, &dtid);
		pvm_freebuf(pvm_getrbuf());  /* for shared memory refcount hang */
		pvm_send(dtid, 2);
/*
		printf("echo %d\n", ++n);
*/
	}
}

