/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ shoalldev.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/shoalldev.c,v $
 *
 * DESCRIPTION:
 *
 *	Show information about ALL devices on the local machine.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:46:29 $ $State: Exp $)
 * $Log: shoalldev.c,v $
 * Revision 1.3  1992/12/22  15:46:29  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:24:43  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:49:22  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"

/*** shoalldev
 *
 *
 *	int shoalldev():
 *	Show status information on ALL of the local NQS devices.
 *
 *	WARNING:
 *		It is assumed that the current position
 *		of the device definitions file is 0.
 *
 *	Returns:
 *		0: If information about one or more devices
 *		   was displayed.
 *	       -1: If no output was produced.
 *
 */
int shoalldev (struct confd *file)
{
	int result;
	register struct gendescr *descr;

	result = -1;			/* No output produced */
	descr = nextdb (file);
	while (descr != (struct gendescr *)0) {
		if (shodbydesc (descr) == 0) {
			/*
			 *  Output was produced.
			 */
			result = 0;
			putchar ('\n');	/* Intervening space */
		}
		descr = nextdb (file);	/* Get the next device */
	}
	return (result);
}
