/*
 * nqs_generic/all-systems/rcimsgs.c
 * Diagnose request code information (RCI).
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* Debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */

#include <stdio.h>		/* FILE definition */
#include <nqs_generic/RCI.h>
  /* NQS information completion codes */

struct TAG_rcimsg_table
{
  long lRciCode;
    /* RCI code to test against */
  char *szPrefix;
    /* Message to output before outputing user-supplied info */
  char *szSuffix;
    /* Message to output after outputting user-supplied info */
};

typedef struct TAG_rcimsg_table rcimsg_table;

static rcimsg_table stRCImsgs [] =
{
  { RCI_ACCESSDEN,	NULL,	"  Access denied;\n"						},
  { RCI_CLIMIDUNKN,	NULL,	"  Client machine-id is unknown at transaction peer;\n"		},
  { RCI_EFBIG,		NULL,	"  File size limit exceeded;\n"					},
  { RCI_FATALABORT,	NULL,	"  Non-recoverable transaction failure;\n"			},
  { RCI_MIDCONFLICT,	NULL,	"  Machine-id conflict between client and destination;\n"	},
  { RCI_NETNOTSUPP,	NULL,	"  Networking not supported at NQS site.\n"			},
  { RCI_NETPASSWD,	NULL,	"  Network password verification error;\n"			},
  { RCI_NOSUCHFORM,	NULL,	"  No such device forms;\n"					},
  { RCI_NOSUCHQUE,	NULL,	"  No such queue;\n"						},
  { RCI_PEERINTERR,	NULL,	"  NQS internal error at transaction peer;\n"			},
  { RCI_PEERMIDUNKN,	NULL,	"  Local machine-id is unknown at transaction peer;\n"		},
  { RCI_PEERNETDB,	NULL,	"  Network database error at transaction peer;\n"		},
  { RCI_PEERNOACATH,	NULL,	"  No account authorization at transaction peer;\n"		},
  { RCI_PROTOFAIL,	NULL,	"  NQS protocol failure;\n"					},
  { RCI_QUOTALIMIT,	NULL,	"  Explicit request quota limits exceed maximums;\n"		},
  { RCI_RRFUNKNMID,	NULL,	"  Request refers to mids unknown at transaction peer;\n"	},
  { RCI_WROQUETYP,	NULL,	"  Wrong queue type for request;\n"				},
  { RCI_UNAFAILURE,	NULL,	"  Unanticipated transaction failure;\n"			},
  { 0,			NULL,	NULL								}
};

/*** rcimsgs
 *
 *	void rcimsgs():
 *	Diagnose request code information bits.
 */
void rcimsgs (
	long code,		/* Completion code */
	FILE *stream,		/* Output stream */
	char *prefix,		/* Output prefix */
	void (*headerfn)(FILE *, char *))	/* Header display function */
{
  register short preamble;	/* Preamble seen flag */
  rcimsg_table   *pstTable;

  ENTER_FUNCTION("nqs_generic/all-systems/rcimsgs");
    /* Debugging info */
  TEST_ARG(stream   != NULL, 2);
  TEST_ARG(prefix   != NULL, 3);
  TEST_ARG(headerfn != NULL, 4);
    /* ensure we are not working with garbage */
  
  preamble = -1;			/* No preamble yet */
  for (pstTable = &stRCImsgs[0]; 
       pstTable->lRciCode != 0 || pstTable->szPrefix != NULL || pstTable->szSuffix != NULL;
       pstTable++)
  {
    if (code & pstTable->lRciCode == 0)
    {
      if (pstTable->szPrefix != NULL)
	fputs(pstTable->szPrefix, stream);
      if (!(++preamble))
	(*headerfn)(stream, prefix);
      if (pstTable->szSuffix != NULL)
	fputs(pstTable->szSuffix, stream);
      fflush(stream);
    }
  }
  EXIT_FUNCTION;
}
