/*
 * nqs_generic/all-systems/grpnam.c
 * 
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */

#include <malloc.h>
#include <string.h>
#include <sys/types.h>
#include <nqs_db/nqs_db.h>

/*** getgrpnam
 *
 *	char *getgrpnam():
 *
 *	Return the groupname for the specified group-id on the local
 *	machine.
 */
char *getgrpnam (gid_t gid)
{
  struct group *pstGroup;
    /* pointer to the group entry */
  
  ENTER_FUNCTION("nqs_generic/all-systems/getgrpnam");
    /* debugging support */
  
  if ((pstGroup = fetchgrgid(gid)) == NULL)
  {
    DEBUGGING(INFO, DEBUG_LOW, "Unable to find any record of group id %d\n", gid);
    EXIT_FUNCTION;
    return NULL;
  }
  else
  {
    EXIT_FUNCTION;
    return (pstGroup->gr_name);
  }
  NEVER;
    /* this should never be reached */
}

/*** endgrpnam
 *
 *	void endgrpnam():
 *	NO-OP.
 */
void endgrpnam (void)
{
  DEBUGGING(INFO, DEBUG_HIGH, "endgrpnam called\n");
    /* 
     * no point in wasting ENTER/EXIT_FUNCTION overheads on an empty
     * function - simply log it so that we can trace where it is called
     * from at a later date
     */
}
