/*
 * nqs_generic/all-systems/getwdir.c
 * Get working directory code
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */

#include <unistd.h>

#define MAXPATHLEN 1500
  /* maximum path length this function can support */

/*** getwdir
 *
 *	char getwdir():
 *
 *	Returns:
 *		A pointer to the fully qualified path name of the
 *		current working directory if successful;
 *		Otherwise, NULL is returned (an error occurred).
 */
char *getwdir (void)
{
  static char szPath [MAXPATHLEN + 1];
  
  ENTER_FUNCTION("nqs_generic/all-systems/getwdir");
  ENSURE_RESOURCE(getcwd(szPath, MAXPATHLEN) != NULL, NQSM_FILEIO_NOCWD);
    /* ensure that we can get a current working directory */
  EXIT_FUNCTION;
  return szPath;
}
