#ifndef __NQS_QUEUE_OMD_HEADER
#define __NQS_QUEUE_OMD_HEADER

/*
 * nqs_queue/all-systems/OMD.h
 * Output mode specifiers for Monsanto-NQS
 */

#include <nqs_generic/license.h>

/*
 *	NQS request output mode specifiers.
 */
#define	OMD_SPOOL	0000001		/* Create stdout/stderr on machine */
					/* that executes the batch req, and */
					/* then spool the stdout/stderr to */
					/* the final destination */
#define	OMD_EO		0000002		/* Direct the stderr output to the */
					/* stdout file for the batch request. */
#define	OMD_NOSPOOL	0000004		/* Create stdout/stderr on named */
					/* machine and access it directly, */
					/* no matter what the network cost. */
					/* The output file is NOT spooled. */
#define	OMD_M_KEEP	0000010		/* The final destination of the */
					/* output file is somewhere on the */
					/* execution machine. */
					/* This flag exists so that a user */
					/* can specify that an output file */
					/* is to be kept on the execution */
					/* machine, without knowing the name */
					/* of the execution machine. */
#define OMD_BBUCKET	0000020		/* Bit bucket the output */

#endif /* __NQS_QUEUE_OMD_HEADER */
