/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ blockdb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/blockdb.c,v $
 *
 * DESCRIPTION:
 *
 *	Return block number for database file offset.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:23:34 $ $State: Exp $)
 * $Log:	blockdb.c,v $
 * Revision 1.2  92/06/18  13:23:34  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  09:51:48  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* Get ATOMICBLKSIZ definition */

/*** blockdb
 *
 *
 *	long blockdb():
 *
 *	Return the block number of the database file for the specified
 *	database file offset.
 *
 *	NOTES:
 *		This function exists ONLY to implement the expression:
 *
 *			blockpos = ((offset / ATOMICBLKSIZ) * ATOMICBLKSIZ);
 *
 *		Unfortunately, we cannot say that directly since smart
 *		C compilers will reduce it to read:
 *
 *			blockpos = offset;
 *
 *		Thus we write (in other modules):
 *
 *			extern long blockdb();
 *				:
 *				:
 *			blockpos = blockdb (offset) * ATOMICBLKSIZ;
 */
long blockdb (long filepos)
{
	return (filepos / ATOMICBLKSIZ);
}
