#! /usr/public/bin/bash
#
# gentable - generate a string catalogue
#
# Stuart Herbert
# Academic Computing Services
# University of Sheffield
#
############################################################################
# Catalogue() - set name of the catalogue
# $1 - Catalogue name

Catalogue ()
{
  Catalogue="$1"
  
  echo "UFCT_LanguageTable ${Catalogue}_Table[]="	>> $szLangTable
  echo "{"						>> $szLangTable
  
  szProceed=YES
}

############################################################################
# EndLanguage() - mark end of a catalogue for a language
# $1 - Language name

EndLanguage ()
{
  if [ "$1" != "$szLanguage" ]; then
    echo "EndLanguage for language $szLanguage missing; $1 found instead."
    exit 1
  fi
  
  echo "  { NULL }" >> $szTable
  echo "};"     >> $szTable
  echo          >> $szTable
  
  echo "  { $szLanguage, &${Catalogue}_$szTableName[0], $iMsgNo }," >> $szLangTable
  echo >> $szCatalogue
  echo "extern UFCT_MessageTable ${Catalogue}_$szTableName[];" >> $szCatalogue
  echo >> $szCatalogue
}

############################################################################
# Language() - define a catalogue for a new language
# $1 - Language name

Language ()
{
  if [ "$szProceed" != "YES" ]; then
    echo "ERROR: Catalogue name not given."
    exit 1
  fi
  
  szOldLanguage=szLanguage
  szLanguage=$1
  szTableName="`echo $1 | cut -c 11-`"
  
  let iMsgNo=0
  let iLangNo=$iLangNo+1
  
  echo "UFCT_MessageTable ${Catalogue}_$szTableName[]="	>> $szTable
  echo "{"						>> $szTable
}

############################################################################
# Message() - add a message to the catalogue
# $1 - Message alias
# $2 - Message text

Message ()
{
 echo "  { \"$2\" },	/* $1 */" >> $szTable
 if [ "$iLangNo" = "1" ]; then
   echo "#define $1	$iMsgNo" >> $szCatalogue
 fi
 let iMsgNo=$iMsgNo+1
}

############################################################################
# main() - it all starts here
#
# $1 - full qualified path name to the catalogue file

if [ ! -f './Catalogue' ]; then
  echo "Message catalogue './Catalogue' not found."
  exit 1
fi

# initialise some variables

szDir="`basename $PWD`"
Catalogue="UFCV_Catalogue"

# create the headers for this module.

szCatalogue="./Catalogue.h"
szTable="./Catalogue.c"
szLangTable="./Table.c"

for x in $szCatalogue $szTable $szLangTable ; do
  if [ -f $x ]; then
    rm -f $x
  fi
done

echo "#ifndef __${szDir}_CATALOGUE_HEADER"			>  $szCatalogue
echo "#define __${szDir}_CATALOGUE_HEADER"			>> $szCatalogue
echo								>> $szCatalogue
echo "/*"							>> $szCatalogue
echo " * Catalogue.h"						>> $szCatalogue
echo " * Macros for using the message catalogue"		>> $szCatalogue
echo " *"							>> $szCatalogue
echo " * Stuart Herbert"					>> $szCatalogue
echo " * Academic Computing Services"				>> $szCatalogue
echo " * University of Sheffield"				>> $szCatalogue
echo " *"							>> $szCatalogue
echo " * NOTE : THIS IS AN AUTOMATICALLY-GENERATED FILE."	>> $szCatalogue
echo " * EDIT AT YOUR OWN RISK"					>> $szCatalogue
echo " */"							>> $szCatalogue
echo								>> $szCatalogue
echo "#include <Catalogue/message.h>"				>> $szCatalogue
echo								>> $szCatalogue

echo "/*"							>> $szTable
echo " * Catalogue.cc"						>> $szTable
echo " * String tables for the message catalogue"		>> $szTable
echo " *"							>> $szTable
echo " * Stuart Herbert"					>> $szTable
echo " * Academic Computing Services"				>> $szTable
echo " * University of Sheffield"				>> $szTable
echo " *"							>> $szTable
echo " * NOTE : THIS IS AN AUTOMATICALLY-GENERATED FILE."	>> $szTable
echo " * EDIT AT YOUR OWN RISK"					>> $szTable
echo " *"							>> $szTable
echo								>> $szTable
echo "#include <Catalogue/message.h>"				>> $szTable
echo								>> $szTable

# set up any other required variables

let iLangNo=0
szOldLanguage=""

. ./Catalogue

cat  $szLangTable 						>> $szTable
rm -f $szLangTable
echo "  { UFCD_LANG_MAX, NULL, 0 }"				>> $szTable
echo "};"							>> $szTable
echo 								>> $szTable
echo "extern UFCT_LanguageTable ${Catalogue}_Table;"		>> $szCatalogue
echo								>> $szCatalogue
echo "#define GET_MESSAGE(x)	UFCF_GetMessage(&${Catalogue}_Table, (x))"	>> $szCatalogue
echo "#define SET_LANGUAGE(x)	UFCF_SetLanguage(x)"		>> $szCatalogue
echo								>> $szCatalogue
echo "#endif /* __${szDir}_CATALOGUE_HEADER */"			>> $szCatalogue

#echo "#endif /* __${szDir}_TABLE_HEADER */"			>> $szTable
