#ifndef __NQS_QUEUE_RQF_HEADER
#define __NQS_QUEUE_RQF_HEADER

/*
 * nqs_queue/all-systems/RQF.h
 * Request flags for Monsanto-NQS
 */

#include <nqs_generic/license.h>

/*
 *	The following request flags are present both in the flags field
 *	of a rawreq structure, and in the status field of a request or
 *	subrequest structure.
 */
#define	RQF_OPERHOLD	0000001		/* An operator hold has been placed */
					/* on the request */
#define	RQF_USERHOLD	0000002		/* A user hold has been placed on */
					/* the request */
#define	RQF_EXTERNAL	0000004		/* Request arrived from another */
					/* remote machine */
#define	RQF_BEGINMAIL	0000010		/* Send mail when the request begins */
					/* execution */
#define	RQF_ENDMAIL	0000020		/* Send mail when the request ends */
					/* execution */
#define	RQF_RESTARTMAIL	0000040		/* Send mail on request restart */
/*
 * V2 of cosmic has the following set a little differently.
 *
 * RESTARTBLE is 400
 * TRANSMAIL  is 100
 * EXPORTVARS is 200
 */
#define	RQF_RESTARTABLE	0000100		/* Request is restartable */
#define	RQF_TRANSMAIL	0000200		/* Send mail when the request */
					/* completes transit to a new queue */
					/* from a pipe queue */
#define RQF_RECOVERABLE 0001000         /* Request is recoverable */
#define RQF_AFTER       0002000         /* this request is really supposed to */
                                        /* run after the time indicated */
#define RQF_SUSPENDED   0004000         /* Request has been suspended by */
                                        /* operator */
#define RQF_BEGINBCST   0010000		/* Broadcast message when the */
					/* request begins execution */
#define RQF_ENDBCST     0020000		/* Broadcast message when the */
					/* request ends execution */
/*
 *	The following request flags are present only in the status field
 *	of a request or subrequest structure.
 */
#define RQF_EXPIRED     0000200000      /* The request is residing in a pipe */
                                        /* or network queue, and has passed  */
                                        /* its delivery expiration time.  The*/
                                        /* next routing or delivery attempt */
                                        /* must succeed, or the request will*/
                                        /* be deleted */
#define RQF_INSTAFILES  0000400000      /* The batch request has files */
                                        /* that need to be staged-in */
#define RQF_PREARRIVE   0001000000      /* The request is in the pre-arrive */
                                        /* state */
#define RQF_PREDEPART   0002000000      /* The request is in the pre-depart */
                                        /* state */
#define RQF_SIGQUEUED   0004000000      /* A signal is queued for this */
                                        /* running request whose process-*/
                                        /* group is not yet known */
#define RQF_SIGREQUEUE  0010000000      /* Request should be requeued if */
                                        /* killed by a signal */
#define RQF_SUBREQUEST  0020000000      /* This request structure is really */
                                        /* a subrequest */
#define RQF_WASEXE      0040000000      /* During rebuild, it was detected */
                                        /* that this request had been */
                                        /* executing at the time of a */
                                        /* system crash, or an orderly */
                                        /* shutdown */
#define RQF_RECOVERED   0100000000      /* Request has been recovered after */
                                        /* an NQS restart following an    */
                                        /* orderly shutdown or crash        */
#define RQF_SIGSAVE     0200000000      /* Request should be "checkpointed" */
                                        /* if killed by a signal */
#define RQF_SIGKILL     0400000000      /* Request should be killed */

#endif /* __NQS_QUEUE_RQF_HEADER */
