#!/bin/sh
#
# platform - generate information strings for the current platform
#
# Stuart Herbert
# Academic Computing Services
# University of Sheffield
#
# Email : S.Herbert@Sheffield.ac.uk
# 
# Based on 'config.guess' from autoconfig-2.1.  Echo's the following to
# stdout :
#
# GENERIC_NAME : GENERIC_NAME+MAJOR_VERSION : GENERIC_NAME+FULL_VERSION
#
# Written by Per Bothner <bothner@cygnus.com>.
# The master version of this file is at the FSF in /home/gd/gnu/lib.

# This is needed to find uname on a Pyramid OSx when run in the BSD universe.
# (ghazi@noc.rutgers.edu 8/24/94.)
if (test -f /.attbin/uname) >/dev/null 2>&1 ; then
	PATH=$PATH:/.attbin ; export PATH
fi

UNAME_MACHINE=`(uname -m) 2>/dev/null` || UNAME_MACHINE=unknown
UNAME_RELEASE=`(uname -r | tr '.' '_') 2>/dev/null` || UNAME_RELEASE=unknown
UNAME_SYSTEM=`(uname -s) 2>/dev/null` || UNAME_SYSTEM=unknown
UNAME_VERSION=`(uname -v) 2>/dev/null` || UNAME_VERSION=unknown

# added by SLH to simplify things
UNAME_MAJOR=`echo $UNAME_RELEASE | cut -d _ -f1` || UNAME_MAJOR=unknown
UNAME_MINOR=`echo $UNAME_RELEASE | cut -d _ -f2` || UNAME_MINOR=unknown
trap 'rm -f dummy.c dummy.o dummy; exit 1' 1 2 15

# Note: order is significant - the case branches are not exclusive.

case "${UNAME_MACHINE}:${UNAME_SYSTEM}:${UNAME_RELEASE}:${UNAME_VERSION}" in
    alpha:OSF1:V*:*)
	# After 1.2, OSF1 uses "V1.3" for uname -r.
	echo "DECOSF:DECOSF_$UNAME_MAJOR:DECOSF_$UNAME_RELEASE:POSIX"
	exit 0 ;;
    alpha:OSF1:*:*)
	# 1.2 uses "1.2" for uname -r.
	echo "DECOSF:DECOSF_$UNAME_MAJOR:DECOSF_$UNAME_RELEASE:POSIX"
        exit 0 ;;
    arm:RISC*:1.[012]*:*|arm:riscix:1.[012]*:*)
        echo "RISCIX:RISCIX_$UNAME_MAJOR:RISCIX_$UNAME_RELEASE:POSIX"
	exit 0;;
    Pyramid*:OSx*:*:*)
	if test "`(/bin/universe) 2>/dev/null`" = att ; then
		echo "PYRAMID:PYRAMID_SYSV3:PYRAMID_SYSV3:SYSV3"
	else
		echo "PYRAMID:PYRAMID_BSD:PYRAMID_BSD:BSD"
	fi
	exit 0 ;;
    sun4*:SunOS:5_*:*)
        echo "SOLARIS:SOLARIS_2:SOLARIS_2_$UNAME_MINOR:SYSV4"
	exit 0 ;;
    sun4*:SunOS:6*:*)
	# According to config.sub, this is the proper way to canonicalize
	# SunOS6.  Hard to guess exactly what SunOS6 will be like, but
	# it's likely to be more like Solaris than SunOS4.
	echo "SOLARIS:SOLARIS_3:SOLARIS_3_$UNAME_MINOR:SYSV4"
	exit 0 ;;
    sun4*:SunOS:*:*)
        echo "SUNOS:SUNOS_$UNAME_MAJOR:SUNOS_$UNAME_RELEASE:BSD"
	exit 0 ;;
    sun3*:SunOS:*:*)
        echo "SUNOS:SUNOS_$UNAME_MAJOR:SUNOS_$UNAME_RELEASE:BSD"
	exit 0 ;;
    RISC*:ULTRIX:*:*)
        echo "ULTRIX:ULTRIX_$UNAME_MAJOR:ULTRIX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    VAX*:ULTRIX*:*:*)
        echo "ULTRIX:ULTRIX_$UNAME_MAJOR:ULTRIX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    mips:*:5*:RISCos)
        echo "RISCOS:RISCOS_$UNAME_MAJOR:RISCOS_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    m88k:CX/UX:7*:*)
        echo "CXUX:CXUX_$UNAME_MAJOR:CXUX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    m88k:*:4*:R4*)
        echo "MOTOROLA:MOTOROLA_SYSV4:MOTOROLA_SYSV4:SYSV4"
	exit 0 ;;
    m88k:*:3*:R3*)
	echo "MOTOROLA:MOTOROLA_SYSV3:MOTOROLA_SYSV3:SYSV3"
	exit 0 ;;
    AViiON:dgux:*:*)
	if [ ${TARGET_BINARY_INTERFACE}x = m88kdguxelfx \
	     -o ${TARGET_BINARY_INTERFACE}x = x ] ; then
	        echo "DGUX:DGUX_$UNAME_MAJOR:DGUX_$UNAME_RELEASE:UNKNOWN"
	else
		echo "DGUXBCS:DGUXBCS_$UNAME_MAJOR:DGUXBCS_$UNAME_RELEASE:UNKNOWN"
	fi
 	exit 0 ;;
    M88*:DolphinOS:*:*)	# DolphinOS (SVR3)
        echo "DOLPHIN:DOLPHIN_$UNAME_MAJOR:DOLPHIN_$UNAME_RELEASE:SYSV3"
	exit 0 ;;
    M88*:*:R3*:*)
	# Delta 88k system running SVR3
	echo "MOTOROLA:MOTOROLA_SYSV3:MOTOROLA_SYSV3:SYSV3"
	exit 0 ;;
    XD88*:*:*:*) # Tektronix XD88 system running UTekV (SVR3)
        echo "TEKTRONIX:TEKTRONIX_SYSV3:TEKTRONIX_SYSV3:SYSV3"
	exit 0 ;;
    Tek43[0-9][0-9]:UTek:*:*) # Tektronix 4300 system running UTek (BSD)
        echo "TEKTRONIX:TEKTRONIX_BSD:TEKTRONIX_BSD:BSD"
	exit 0 ;;
    *:IRIX:*:*)
        echo "IRIX:IRIX_$UNAME_MAJOR:IRIX_$UNAME_RELEASE:SYSV4"
	exit 0 ;;
    i[34]86:AIX:*:*)
        echo "AIX:AIX_$UNAME_MAJOR:AIX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    *:AIX:2:3)
	if grep bos325 /usr/include/stdio.h >/dev/null 2>&1; then
		sed 's/^		//' << EOF >dummy.c
		#include <sys/systemcfg.h>

		main()
			{
			if (!__power_pc())
				exit(1);
			puts("AIX:AIX_3:AIX_3_2_5:UNKNOWN");
			exit(0);
			}
EOF
		${CC-cc} dummy.c -o dummy && ./dummy && rm dummy.c dummy && exit 0
		rm -f dummy.c dummy
		echo "AIX:AIX_3:AIX_3_2_5:UNKNOWN"
	elif grep bos324 /usr/include/stdio.h >/dev/null 2>&1; then
		echo "AIX_AIX_3:AIX_3_2_4:UNKNOWN"
	else
		echo "AIX_AIX_3:AIX_3_2:UNKNOWN"
	fi
	exit 0 ;;
    *:AIX:*:4)
	if /usr/sbin/lsattr -EHl proc0 | grep POWER >/dev/null 2>&1; then
		IBM_ARCH=rs6000
	else
		IBM_ARCH=powerpc
	fi
	if grep bos410 /usr/include/stdio.h >/dev/null 2>&1; then
		UNAME_MAJOR=4
		UNAME_RELEASE=4_1
	elif grep bos411 /usr/include/stdio.h >/dev/null 2>&1; then
		UNAME_MAJOR=4
		UNAME_RELEASE=4_1_1
	else
		UNAME_MAJOR=4
		UNAME_RELEASE=4.`echo ${UNAME_RELEASE} | tr '.' '_'`
	fi
	echo "AIX:AIX_$UNAME_MAJOR:AIX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    *:AIX:*:*)
	echo "AIX:AIX_$UNAME_MAJOR:AIX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    *:BOSX:*:*)
	echo "BOSX:BOSX_$UNAME_MAJOR:BOSX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    DPX/2?00:B.O.S.:*:*)
    	echo "BULL:BULL_$UNAME_MAJOR:BULL_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    9000/[34]??:4.3bsd:1.*:*)
    	echo "BSD:BSD_$UNAME_MAJOR:BSD_$UNAME_RELEASE:BSD"
	exit 0 ;;
    hp300:4.4BSD:*:* | 9000/[34]??:4.3bsd:2.*:*)
    	echo "BSD:BSD_4:BSD_4_4:BSD"
	exit 0 ;;
    9000/[3478]??:HP-UX:*:*)
	case "${UNAME_MACHINE}" in
	    9000/31? )            HP_ARCH=m68000 ;;
	    9000/[34]?? )         HP_ARCH=m68k ;;
	    9000/7?? | 9000/8?7 ) HP_ARCH=hppa1.1 ;;
	    9000/8?? )            HP_ARCH=hppa1.0 ;;
	esac
	HPUX_REV=`echo ${UNAME_RELEASE}|sed -e 's/[^.]*.[0B]*//'|tr '.' '_'`
	$UNAME_MAJOR=`echo $HPUX_REV | cut -d_ -f1`
	echo "HPUX:HPUX_$UNAME_MAJOR:HPUX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    3050*:HI-UX:*:*)
    	echo "HIUX:HIUX_$UNAME_MAJOR:HIUX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    9000/7??:4.3bsd:*:* | 9000/8?7:4.3bsd:*:* )
    	echo "BSD:BSD_4:BSD_4_3:BSD"
	exit 0 ;;
    9000/8??:4.3bsd:*:*)
    	echo "BSD:BSD_4:BSD_4.3:UNKNOWN"
	exit 0 ;;
    hp7??:OSF1:*:* | hp8?7:OSF1:*:* )
        echo "HPOSF:HPOSF_$UNAME_MAJOR:HPOSF_$UNAME_RELEASE:POSIX"
	exit 0 ;;
    hp8??:OSF1:*:*)
    	echo "HPOSF:HPOSF_$UNAME_MAJOR:HPOSF_$UNAME_RELEASE:POSIX"
	exit 0 ;;
    C1*:ConvexOS:*:* | convex:ConvexOS:C1*:*)
    	echo "CONVEX:CONVEX_$UNAME_MAJOR:CONVEX_$UNAME_RELEASE:UNKNOWN"
        exit 0 ;;
    C2*:ConvexOS:*:* | convex:ConvexOS:C2*:*)
    	echo "CONVEX:CONVEX_$UNAME_MAJOR:CONVEX_$UNAME_RELEASE:UNKNOWN"
        exit 0 ;;
    C34*:ConvexOS:*:* | convex:ConvexOS:C34*:*)
    	echo "CONVEX:CONVEX_$UNAME_MAJOR:CONVEX_$UNAME_RELEASE:UNKNOWN"
        exit 0 ;;
    C38*:ConvexOS:*:* | convex:ConvexOS:C38*:*)
    	echo "CONVEX:CONVEX_$UNAME_MAJOR:CONVEX_$UNAME_RELEASE:UNKNOWN"
        exit 0 ;;
    C4*:ConvexOS:*:* | convex:ConvexOS:C4*:*)
    	echo "CONVEX:CONVEX_$UNAME_MAJOR:CONVEX_$UNAME_RELEASE:UNKNOWN"
        exit 0 ;;
    CRAY*X-MP:UNICOS:*:*)
    	echo "UNICOS:UNICOS_$UNAME_MAJOR:UNICOS_$UNAME_RELEASE:UNKNOWN"
        exit 0 ;;
    CRAY*Y-MP:UNICOS:*:*)
    	echo "UNICOS:UNICOS_$UNAME_MAJOR:UNICOS_$UNAME_RELEASE:UNKNOWN"
        exit 0 ;;
    CRAY-2:UNICOS:*:*)
    	echo "UNICOS:UNICOS_$UNAME_MAJOR:UNICOS_$UNAME_RELEASE:UNKNOWN"
        exit 0 ;;
    hp3[0-9][05]:NetBSD:*:*)
    	echo "NETBSD:NETBSD_$UNAME_MAJOR:NETBSD_$UNAME_RELEASE:BSD"
	exit 0 ;;
    i[34]86:BSD/386:*:*)
    	echo "BSDI:BSDI_$UNAME_MAJOR:BSDI_$UNAME_RELEASE:BSD"
	exit 0 ;;
    *:FreeBSD:*:*)
        echo "FREEBSD:FREEBSD_$UNAME_MAJOR:FREEBSD_$UNAME_RELEASE:BSD"
	exit 0 ;;
    *:NetBSD:*:*)
    	echo "NETBSD:NETBSD_$UNAME_MAJOR:NETBSD_$UNAME_RELEASE:BSD"
	exit 0 ;;
    *:GNU:*:*)
    	echo "HURD:HURD_$UNAME_MAJOR:HURD_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    *:Linux:*:*)
    	echo "LINUX:LINUX_$UNAME_MAJOR:LINUX_$UNAME_RELEASE:BSD"
	exit 0 ;;
# ptx 4.0 does uname -s correctly, with DYNIX/ptx in there.  earlier versions
# are messed up and put the nodename in both sysname and nodename.
    i[34]86:DYNIX/ptx:4*:*)
    	echo "DYNIX:DYNIX_$UNAME_MAJOR:DYNIX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    i[34]86:*:4.*:* | i[34]86:SYSTEM_V:4.*:*)
	echo "SYSV:SYSV_$UNAME_MAJOR:SYSV_$UNAME_RELEASE:SYSV4"
	exit 0 ;;
    i[34]86:*:3.2:*)
	if /bin/uname -X 2>/dev/null >/dev/null ; then
		UNAME_REL=`(/bin/uname -X|egrep Release|sed -e 's/.*= //')`
		(/bin/uname -X|egrep i80486 >/dev/null) && UNAME_MACHINE=i486
		echo "XENIX:XENIX_$UNAME_MAJOR:XENIX_$UNAME_REL:UNKNOWN"
	elif test -f /usr/options/cb.name; then
		UNAME_REL=`sed -n 's/.*Version //p' </usr/options/cb.name`
		echo "ISC:ISC_$UNAME_MAJOR:ISC_$UNAME_REL:UNKNOWN"
	else
		echo "SYSV:SYSV_3:SYSV_3_2:SYSV3"
	fi
	exit 0 ;;
    Intel:Mach:3*:*)
    	echo "MACH:MACH_$UNAME_MAJOR:MACH_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    i860:*:4.*:*) # i860-SVR4
	if grep Stardent /usr/include/sys/uadmin.h >/dev/null 2>&1 ; then
	  echo "STARDENT:STARDENT_$UNAME_MAJOR:STARDENT_$UNAME_RELEASE:SYSV4"
	else # Add other i860-SVR4 vendors below as they are discovered.
	  echo "SYSV:SYSV_$UNAME_MAJOR:SYSV_$UNAME_RELEASE:SYSV4"
	fi
	exit 0 ;;
    mini*:CTIX:SYS*5:*)
	# "miniframe"
	echo "CTIX:CTIX_$UNAME_MAJOR:CTIX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    M680[234]0:*:R3V[567]*:*)
	test -r /sysV68 && echo "MOTOROLA:MOTOROLA_$UNAME_MAJOR:MOTOROLA_$UNAME_RELEASE:UNKNOWN" && exit 0 ;;
    3[34]??:*:4.0:3.0 | 3[34]??,*:*:4.0:3.0)
        uname -p 2>/dev/null | grep 86 >/dev/null \
          && echo "NCR:NCR_$UNAME_MAJOR:NCR_$UNAME_RELEASE:SYSV4" && exit 0 ;;
    3[34]??:*:4.0:* | 3[34]??,*:*:4.0:*)
        uname -p 2>/dev/null | grep 86 >/dev/null \
          && echo "NCR:NCR_$UNAME_MAJOR:NCR_$UNAME_RELEASE:SYSV4" && exit 0 ;;
    m680[234]0:LynxOS:2.2*:*)
    	echo "LYNX:LYNX_$UNAME_MAJOR:LYNX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    mc68030:UNIX_System_V:4.*:*)
    	echo "ATARI:ATARI_$UNAME_MAJOR:ATARI_$UNAME_RELEASE:SYSV4"
	exit 0 ;;
    i[34]86:LynxOS:2.2*:*)
    	echo "LYNX:LYNX_$UNAME_MAJOR:LYNX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    TSUNAMI:LynxOS:2.2*:*)
    	echo "LYNX:LYNX_$UNAME_MAJOR:LYNX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    rs6000:LynxOS:2.2*:*)
    	echo "LYNX:LYNX_$UNAME_MAJOR:LYNX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    RM*:SINIX-*:*:*)
    	echo "SINIX:SINIX_$UNAME_MAJOR:SINIX_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
    *:SINIX-*:*:*)
	echo "SINIX:SINIX_$UNAME_MAJOR:SINI_$UNAME_RELEASE:UNKNOWN"
	exit 0 ;;
esac

#echo '(No uname command or uname output not recognized.)' 1>&2
#echo "${UNAME_MACHINE}:${UNAME_SYSTEM}:${UNAME_RELEASE}:${UNAME_VERSION}" 1>&2

cat >dummy.c <<EOF
main ()
{
#if defined (sony)
#if defined (MIPSEB)
  /* BFD wants "bsd" instead of "newsos".  Perhaps BFD should be changed,
     I don't know....  */
  printf ("SONY:SONY_$UNAME_MAJOR:SONY_$UNAME_RELEASE:BSD\n"); exit (0);
#else
  printf ("SONY:SONY_$UNAME_MAJOR:SONY_$UNAME_RELEASE:BSD\n"); exit (0);
#endif
#endif

#if defined (__arm) && defined (__acorn) && defined (__unix)
  printf ("RISCIX:RISCIX_$UNAME_MAJOR:RISIX_$UNAME_RELEASE:UNKNOWN"); exit (0);
#endif

#if defined (hp300) && !defined (hpux)
  printf ("BSD:BSD_$UNAME_MAJOR:BSD_$UNAME_RELEASE:BSD\n"); exit (0);
#endif

#if defined (NeXT)
#if !defined (__ARCHITECTURE__)
#define __ARCHITECTURE__ "m68k"
#endif
  int version;
  version=`(hostinfo | sed -n 's/.*NeXT Mach \([0-9]*\).*/\1/p') 2>/dev/null`;
  printf ("NEXTSTEP:NEXTSTEP_$UNAME_MAJOR:NEXTSTEP_$UNAME_RELEASE:UNKNOWN\n");
  exit (0);
#endif

#if defined (MULTIMAX) || defined (n16)
#if defined (UMAXV)
  printf ("ENCORE_SYSV:ENCORE_SYSV_$UNAME_MAJOR:ENCORE_SYSV_$UNAME_RELEASE:SYSV\n"); exit (0);
#else
#if defined (CMU)
  printf ("ENCORE_MACH:ENCORE_MACH_$UNAME_MAJOR:ENCORE_MACH_$UNAME_RELEASE:UNKNOWN\n"); exit (0);
#else
  printf ("ENCORE_BSD:ENCORE_BSD_$UNAME_MAJOR:ENCORE_BSD_$UNAME_RELEASE:BSD\n"); exit (0);
#endif
#endif
#endif

#if defined (__386BSD__)
  printf ("BSD:BSD_$UNAME_MAJOR:BSD_$UNAME_RELEASE:BSD\n"); exit (0);
#endif

#if defined (sequent)
#if defined (i386)
  printf ("DYNIX:DYNIX_$UNAME_MAJOR:DYNIX_$UNAME_RELEASE:UNKNOWN\n"); exit (0);
#endif
#if defined (ns32000)
  printf ("DYNIX:DYNIX_$UNAME_MAJOR:DYNIX_$UNAME_RELEASE:UNKNOWN\n"); exit (0);
#endif
#endif

#if defined (_SEQUENT_)
  printf ("PTX:PTX_$UNAME_MAJOR:PTX_$UNAME_RELEASE:UNKNOWN\n"); exit (0);
#endif

#if defined (vax)
#if !defined (ultrix)
  printf ("BSD:BSD_$UNAME_MAJOR:BSD_$UNAME_RELEASE:BSD\n"); exit (0);
#else
  printf ("ULTRIX:ULTRIX_$UNAME_MAJOR:ULTRIX_$UNAME_RELEASE:UNKNOWN\n"); exit (0);
#endif
#endif

#if defined (alliant) && defined (i860)
  printf ("ALLIANT:ALLIANT_$UNAME_MAJOR:ALLIANT_$UNAME_RELEASE:BSD\n"); exit (0);
#endif

  exit (1);
}
EOF

${CC-cc} dummy.c -o dummy 2>/dev/null && ./dummy && rm dummy.c dummy && exit 0
rm -f dummy.c dummy

#echo '(Unable to guess system type)' 1>&2

exit 1
