/*
 * nqs_generic/all-systems/get_timezone.c
 * Obtain timezone information
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototype support */

#include <time.h>
#include <stdio.h>

short get_timezone (struct tm **tm)
{
  short  local_zone;
  time_t timeinsecs;		/* Time in seconds from 0:00:00 */
				/* January 1, 1970-GMT */
  /*
   *  Get the current time/date and local timezone for later use.
   */

  ENTER_FUNCTION("nqs_generic/all-systems/get_timezone");
  TEST_ARG(tm != NULL, 1);
    /* ensure we are not working with garbage */
  
  time (&timeinsecs);		/* Get current time */
  tzset();			/* Get local timezone */
  local_zone = timezone / 60;	/* Timezone in minutes west from GMT */
  *tm = localtime (&timeinsecs);
  
  EXIT_FUNCTION;
  return local_zone;
}
