/*
 * nqs_generic/all-systems/fmtgidname.c
 * Format a gid in a string.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */
#include <nqs_db/nqs_db.h>
  /* /etc/group (or equivalent) support */

/*** fmtgidname
 *
 *	char *fmtgidname():
 *
 *	Return a pointer to the groupname of the group
 *	identified by the local group-id.
 */

char *fmtgidname (gid_t gid)
{
  static char szStandInBuf [17];
    /* Stand-in buffer */

  register char *szName;
    /* Pointer to name */

  ENTER_FUNCTION("nqs_generic/all-systems/fmtgidname");
    /* debugging information */
  
  szName = getgrpnam(gid);
    /* Get group entry */
  
  if ((szName = getgrpnam(gid)) == NULL)
  {
    /*
     *  No such group!  Format a "stand-in" name.
     */
    sprintf (szStandInBuf, "[%1d]", (int) gid);
    szName = szStandInBuf;
  }
  
  EXIT_FUNCTION;
  return (szName);
}
