/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     14-Nov-1991	Modified for yp problem on ddpi7.
*       V01.30  JRR     16-Jan-1992	Added support for RS6000.
*       V01.4   JRR     28-Feb-1992	Added Cosmic V2 changes.
*       V01.5   JRR     07-Apr-1992     Added CERN enhancements.
*	V01.6	JRR	17-Jun-1992	Added header.
*/
/*++ fetchpwdb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/fetchpwdb.c,v $
 *
 * DESCRIPTION:
 *
 *	This module contains three functions:
 *
 *		fetchpwuid(),
 *		fetchpwnam(), and
 *		closepwdb()
 *
 *	that respectively return the passwd structure for the specified
 *	local user-id, return the passwd structure for the specified
 *	local username, and close the local account/password database
 *	opened by fetchpwuid() or fetchpwnam().
 *
 *	This module is provided as an "onion-skin layer" residing above
 *	the locally implemented account/password database access
 *	functions.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	January 20, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.7 $ $Date: 92/06/18 13:23:44 $ $State: Exp $)
 * $Log:	fetchpwdb.c,v $
 * Revision 1.7  92/06/18  13:23:44  jrroma
 * Added gnu header
 * 
 * Revision 1.6  92/05/06  10:10:18  jrroma
 * Version 3.20
 * 
 * Revision 1.5  92/02/28  13:56:02  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.4  92/01/16  15:38:08  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.3  91/11/14  09:23:10  jrroma
 * Checked to see if printf commented out.
 * 
 * Revision 1.2  91/11/05  11:21:53  jrroma
 * Modified to work with yellow pages problem on ddpi7
 * 
 *
 */

#include <stdio.h>			/* for definition of L_cuserid */
#include <pwd.h>			/* Password file structures */


/*
 *	External functions.
 */
extern void endpwent();			/* Close password file */


/*** fetchpwuid
 *
 *
 *	struct passwd *fetchpwuid():
 *	Return struct passwd structure for the specified local user-id.
 *
 *	NOTE:	This function does not open and close the
 *		account/password database on successive
 *		invocations.  It is up to the caller to
 *		invoke closepwdb() when access to the
 *		account/password database is no longer
 *		required.
 */
struct passwd *fetchpwuid (int uid)
{
    return ( getpwuid (uid) );
}


/*** fetchpwnam
 *
 *
 *	struct passwd *fetchpwnam():
 *	Return struct passwd structure for the specified local username.
 *
 *	NOTE:	This function does not open and close the
 *		account/password database on successive
 *		invocations.  It is up to the caller to
 *		invoke closepwdb() when access to the
 *		account/password database is no longer
 *		required.
 */
struct passwd *fetchpwnam (char *name)
{
    return ( getpwnam (name) );
}


/*** closepwdb
 *
 *
 *	void closepwdb():
 *
 *	Close the local account/password database opened by fetchpwuid(),
 *	or by fetchpwnam().
 */
void closepwdb()
{
	endpwent();			/* Close the local password file */
}
