#ifndef __NQS_GENERIC_PROTO_HEADER
#define __NQS_GENERIC_PROTO_HEADER

/*
 * nqs_generic/all-systems/proto.h
 * Prototypes for functions in the nqs_generic library.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <grp.h>
  /* for definition of gid_t type */
#include <nmap/nmap.h>
  /* for definition of mid_t type - to be REMOVED in the future */
#include <stdio.h>
  /* for definition of FILE */
#include <sys/types.h>
  /* for definition of time_t */
#include <nqs_queue/quolim.h>
  /* for definition of struct cpulimit */
#include <nqs_generic/tblmsgs.h>
  /* for definition of msgs_table */

/*
 * NOTE - a non-ANSI C compiler will choke on this file.
 * This is not our problem ... you should obtain such a compiler
 * from your vendor, or use the GNU GCC compiler instead.
 */

extern char *	asciierrno	(void);

extern void 	bufstderr	(void);
extern void	bufstdout	(void);
extern int	buildenv	(void);
extern void     bytecopy	(char *, char *, int);
extern void	bytezero	(char *, int);

extern int	cpulimhigh	(unsigned long, short, short, unsigned long *,
				 short *);
extern int	cpulimlow	(unsigned long, short, short, unsigned long *,
				 short *);
extern void	endgrpnam	(void);
extern long	errnototcm	(void);

extern long	filecopyentire	(int, int);
extern long	filecopysized	(int, int, long);
extern char *	fmtgidname	(gid_t);
extern char *	fmtmidname	(Mid_t);
extern char *	fmttime		(time_t *);
extern char *	fmtuidname	(uid_t);
extern FILE *	fopendata	(long, Mid_t, int);

extern char *	getenviron	(char *);
extern char *	getfilnam	(char *, short);
extern char *	getgrpnam	(gid_t);
extern char *	getwdir		(void);
extern short	get_timezone	(struct tm **);

extern int	isdecstr	(char *, int);

extern void	ldparam		(void);

extern int	match		(char *, char *);
extern int	matche		(char *, char *);
extern long	mergertcm	(long, long);

extern void	nqssleep	(int);

extern void	pack6name	(char *, char *, int, char *, long, int, long, 
				 int, int, int);
extern int	parseserv	(char *, char **);

extern void	rcimsgs		(long, FILE *, char *, void (*)(FILE *, char *));
extern void	relfilnam	(char *);

extern int	scancpulim	(char *, struct cpulimit *, short);
extern int	scanquolim	(char *, struct quotalimit *, short);
extern int	scantime	(char *, time_t *, int);
extern int	scnctime	(char *, time_t *);
extern int	scnftime	(char *, time_t *);
extern int	scnptime	(char *, time_t *);
extern int	secgrfir	(unsigned long, short, unsigned long, short);
extern void	serexit		(long, char [256]);

extern void	tblmsgs		(long, FILE *, char *, void (*)(FILE *, char *), msg_table *);
extern void	tcimsgs		(long, FILE *, char *, void (*)(FILE *, char *));
extern void	tcmmsgs		(long, FILE *, char *prefix);

#endif /* __NQS_GENERIC_PROTO_HEADER */
