/*
 * nqs_generic/all-systems/ldparam.c
 * Load general NQS parameters from the database.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */
#include <nqs_generic/nqs_generic.h>
#include <nqsd/nqsxvars.h>
  /* External global variables */
#include <nqs_generic/nqsxdirs.h>
#include <nqs_db/nqs_db.h>

/*** ldparam
 *
 *	void ldparam():
 *	Load the general NQS operating parameters.
 */
void ldparam (void)
{
  register struct gendescr *gendescr;
    /* Database descriptor */
  char	*daemon;
    /* Fully quailified name */

  ENTER_FUNCTION("nqs_generic/all-systems/ldparam");
    /* debugging information */
  
  /*
   *  Read and process the general NQS operating parameters
   *  from the NQS parameter file.
   */
  
  Debug = 0;				/* Set up defaults */
  Defbatpri = MAX_RPRIORITY / 2;
  LB_Scheduler = 0;
  Defbatque [0] = '\0';
  Defdesrettim = 3600L * 24 * 3;		/* 3 days of patience */
  Defdesretwai = 300;			/* 5-minute dest retry waits */
  Defdevpri = MAX_RPRIORITY / 2;
  Defnetrettim = 3600L * 24 * 3;		/* 3 days of patience */
  Defnetretwai = 300;			/* 5-minute net retry waits */
  Defloadint = 180;			/* 3-minute load reports */
  Defprifor [0] = '\0';
  Defprique [0] = '\0';
  Fixed_shell [0] = '\0';			/* No fixed shell by default */
  Lifetime = 86400 * 7;			/* 1-week pipe queue lifetime */
  Logfilename [0] = '\0';			/* No default logfile */
   /* TAC Intergraph gave logfile default strcpy(Logfilename,"/usr/lib/nqs                /logfile");     */
  Maxcopies = 2;
  Maxextrequests = MAX_EXTREQUESTS;
  Maxgblacclimit = MAX_GBLACCLIMIT;
  Maxgblbatlimit = MAX_GBLBATLIMIT;
  Maxgblnetlimit = MAX_GBLNETLIMIT;
  Maxgblpiplimit = MAX_GBLPIPLIMIT;
  Maxoperet = 2;
  Maxprint = 1000000;
  Mail_uid = 0;				/* Default mail acct is root */
  daemon = getfilnam ("netdaemon", LIBDIR);
  ENSURE_DATA(daemon != NULL, UFCM_ERRD_NULLPTR);
  strcpy (Netdaemon, daemon);             /* Default network daemon */
  relfilnam (daemon);

  daemon = getfilnam ("netserver", LIBDIR);
  ENSURE_DATA(daemon != NULL, UFCM_ERRD_NULLPTR);
  strcpy (Netserver, daemon);             /* Default network server */
  relfilnam (daemon);

  daemon = getfilnam ("netclient", LIBDIR);
  ENSURE_DATA(daemon != NULL, UFCM_ERRD_NULLPTR);
  strcpy (Netclient, daemon);             /* Default emptier of */
  relfilnam (daemon);                     /* network queues */

  daemon = getfilnam ("loaddaemon", LIBDIR);
  ENSURE_DATA(daemon != NULL, UFCM_ERRD_NULLPTR);
  strcpy (Loaddaemon, daemon);             /* Default load daemon */
  relfilnam (daemon);
  
  Opewai = 5;
  Plockdae = 0;				/* Not locked in mem by def */
  Shell_strategy = SHSTRAT_FREE;		/* Free shell-choice */
  Termsignal = TERMSIG_DEFAULT;		/* Default request termsig */
  Udbgenparams = -1;			/* Offset of these three */
  Udbnetprocs = -1;			/* database records is */
  Udblogfile = -1;			/* not known */
  
  gendescr = nextdb (Paramfile);
  while (gendescr != NULL &&
         gendescr->v.par.paramtype != PRM_NETPEER)
  {
    /*
     *  This entry defines the general NQS operating parameters
     *  record, the logfile record, or the network server definition
     *  record.  These three (3) records ALWAYS appear as the first
     *  three records in the parameters file.
     */
    switch (gendescr->v.par.paramtype)
    {
     case PRM_GENPARAMS:
      Udbgenparams = telldb (Paramfile);
      Mail_uid = gendescr->v.par.v.genparams.mail_uid;
      Maxgblacclimit = gendescr->v.par.v.genparams.maxgblacclimit;
      Maxgblbatlimit = gendescr->v.par.v.genparams.maxgblbatlimit;
      Maxgblnetlimit = gendescr->v.par.v.genparams.maxgblnetlimit;
      Maxgblpiplimit = gendescr->v.par.v.genparams.maxgblpiplimit;
      Plockdae = gendescr->v.par.v.genparams.plockdae;
      Shell_strategy = gendescr->v.par.v.genparams.shell_strategy;
      Termsignal = gendescr->v.par.v.genparams.termsignal;
      Debug = gendescr->v.par.v.genparams.debug;
      LB_Scheduler = gendescr->v.par.v.genparams.lb_scheduler;
      Defbatpri = gendescr->v.par.v.genparams.defbatpri;
      Defdevpri = gendescr->v.par.v.genparams.defdevpri;
      Maxcopies = gendescr->v.par.v.genparams.maxcopies;
      Maxextrequests = gendescr->v.par.v.genparams.maxextrequests;
      Maxoperet = gendescr->v.par.v.genparams.maxoperet;
      Maxprint = gendescr->v.par.v.genparams.maxprint;
      Opewai = gendescr->v.par.v.genparams.opewai;
      Defdesrettim = gendescr->v.par.v.genparams.defdesrettim;
      Defdesretwai = gendescr->v.par.v.genparams.defdesretwai;
      Defnetrettim = gendescr->v.par.v.genparams.defnetrettim;
      Defloadint = gendescr->v.par.v.genparams.defloadint;
      Defnetretwai = gendescr->v.par.v.genparams.defnetretwai;
      Lifetime = gendescr->v.par.v.genparams.lifetime;
      ENSURE_DATA(gendescr->v.par.v.genparams.defprifor != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Defprifor, gendescr->v.par.v.genparams.defprifor);
      ENSURE_DATA(gendescr->v.par.v.genparams.defbatque != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Defbatque, gendescr->v.par.v.genparams.defbatque);
      ENSURE_DATA(gendescr->v.par.v.genparams.defprique != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Defprique, gendescr->v.par.v.genparams.defprique);
      ENSURE_DATA(gendescr->v.par.v.genparams.fixed_shell != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Fixed_shell, gendescr->v.par.v.genparams.fixed_shell);
      ENSURE_DATA(gendescr->v.par.v.genparams.netdaemon != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Netdaemon, gendescr->v.par.v.genparams.netdaemon);
      ENSURE_DATA(gendescr->v.par.v.genparams.loaddaemon != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Loaddaemon, gendescr->v.par.v.genparams.loaddaemon);
      break;
     case PRM_LOGFILE:
      Udblogfile = telldb (Paramfile);
      ENSURE_DATA(gendescr->v.par.v.logfile != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Logfilename, gendescr->v.par.v.logfile);
      break;
     case PRM_NETPROCS:
      Udbnetprocs = telldb (Paramfile);
      ENSURE_DATA(gendescr->v.par.v.netprocs.netserver != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Netserver, gendescr->v.par.v.netprocs.netserver);
      ENSURE_DATA(gendescr->v.par.v.netprocs.netclient != NULL, UFCM_ERRD_NULLPTR);
      strcpy (Netclient, gendescr->v.par.v.netprocs.netclient);
      break;
    }
    gendescr = nextdb (Paramfile);
  }
  EXIT_FUNCTION;
}
