/*
 * nqs_generic/BSD/fmttime.c
 * Format a time string.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */

#include <sys/types.h>			/* time_t */
#include <sys/time.h>
#include <stdio.h>

extern char *timezone();

/*
 * FIXME:
 * where does that variable come from?
 */

/*** fmttime
 *
 *	char *fmttime():
 *
 *	Return a pointer to a formatted time string where the time
 *	is specified as a long integer defining the number of seconds
 *	since 00:00:00 GMT, January 1, 1970.
 */
char *fmttime (time_t *pstTimeinsecs)
{
  static char szBuffer [40];
    /* Output buffer */
  char *szTzn;
    /* Time zone name */
  char *szTs;
    /* Time string */
  struct tm *pstTp;
    /* Time structure pointer */

  struct timeval  stTv;
  struct timezone stTz;

  ENTER_FUNCTION("nqs_generic/BSD/fmttime");
    /* debugging support */
  
  gettimeofday (&stTv, &stTz);
  pstTp = localtime (pstTimeinsecs);
  szTs = asctime (pstTp);
  szTzn = timezone (stTz.tz_minuteswest, pstTp->tm_isdst);

  if (szTzn == NULL)
    *szTzn = '\0';
  
  szTs [24] = '\0';
    /* Zap newline character */
  sprintf (szBuffer, "%.20s%s%s", szTs, szTzn, szTs+19);
  return (szBuffer);
}
