/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ tcimsgs.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/tcimsgs.c,v $
 *
 * DESCRIPTION:
 *
 *
 *	Diagnose transaction code information bits.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	April 28, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:24:54 $ $State: Exp $)
 * $Log:	tcimsgs.c,v $
 * Revision 1.2  92/06/18  13:24:54  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:50:46  jrroma
 * Initial revision
 * 
 *
 */

#include <stdio.h>		/* FILE definition */
#include "informcc.h"		/* NQS information completion codes */

/*** tcimsgs
 *
 *
 *	void tcimsgs():
 *	Diagnose transaction code information bits.
 */
void tcimsgs (
	long code,			/* Completion code */
	FILE *stream,			/* Output stream */
	char *prefix,			/* Output prefix */
	void (*headerfn)())		/* Header display function */
{
	register short preamble;	/* Preamble seen flag */

	preamble = -1;			/* No preamble yet */
	if (code & TCI_COPLIMEXC) {
		preamble = 0;
		(*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Copy limit;\n", stream);
	}
	if (code & TCI_PP_CFLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process core-file size limit;\n", stream);
	}
	if (code & TCI_PP_CTLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process CPU time limit;\n", stream);
	}
	if (code & TCI_PP_DSLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process data-segment limit;\n", stream);
	}
	if (code & TCI_PP_MSLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process memory size limit;\n", stream);
	}
	if (code & TCI_PP_NELEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process nice execution priority limit;\n",
		       stream);
	}
	fflush (stream);		/* For logfile */
	if (code & TCI_PP_PFLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process permanent file size limit;\n", stream);
	}
	if (code & TCI_PP_QFLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process quick file size quota limit;\n", stream);
	}
	if (code & TCI_PP_SSLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process stack-segment limit;\n", stream);
	}
	if (code & TCI_PP_TFLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process temporary file size limit;\n", stream);
	}
	if (code & TCI_PP_WSLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-process working set quota limit;\n", stream);
	}
	if (code & TCI_PRILIMEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Print/output size limit;\n", stream);
	}
	fflush (stream);		/* For logfile */
	if (code & TCI_PR_CTLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-request CPU time limit;\n", stream);
	}
	if (code & TCI_PR_DRIEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-request tape drive quota limit;\n", stream);
	}
	if (code & TCI_PR_MSLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-request memory space limit;\n", stream);
	}
	if (code & TCI_PR_NCPEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-request CPU quota limit;\n", stream);
	}
	if (code & TCI_PR_PFLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-request permanent file space limit;\n", stream);
	}
	if (code & TCI_PR_QFLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-request quick file space quota limit;\n", stream);
	}
	if (code & TCI_PR_TFLEXC) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Per-request temporary file space limit;\n", stream);
	}
	fflush (stream);		/* For logfile */
}
