/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ closedb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.36/lib/RCS/closedb.c,v $
 *
 * DESCRIPTION:
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1994/09/02 17:37:55 $ $State: Exp $)
 * $Log: closedb.c,v $
 * Revision 1.3  1994/09/02  17:37:55  jrroma
 * Version 3.36
 *
 * Revision 1.2  1992/06/18  13:23:37  jrroma
 * Added gnu header
 *
 * Revision 1.1  92/06/18  09:52:48  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"


/*** closedb
 *
 *
 *	void closedb():
 *	Close the specified NQS database/configuration file.
 */
void closedb (struct confd *file)
{
	if (file->fd >= 0) {
		close (file->fd);	/* Close the file */
		file->fd = -1;		/* Mark confd file descriptor */
					/* as free */
		free ((char *) file->cache);
					/* Free read cache buffer */
	}
}
