/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.30  JRR     22-Jan-1992	Set what seem to be proper limits
*					for the RS6000.
*       V01.4   JRR     07-Apr-1992     Add CERN enhancements.
*			29-Apr-1992     Adjust defaults.
*	V01.5	JRR	17-Jun-1992	Added header.	
*	V01.6	JRR	11-Nov-1992	Added support for HPUX.
*	V01.7	JRR	28-Feb-1994	Added support for SOLARIS.
*/
/*++ nqsdeflim.h - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/h/RCS/nqsdeflim.h,v $
 *
 * DESCRIPTION:
 *
 *	Default batch queue resource limits are defined here.
 *
 *
 *	Author:
 *	-------
 *	Robert W. Sandstrom, Sterling Software Incorporated.
 *	February 13, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.7 $ $Date: 1994/03/30 20:31:39 $ $State: Exp $)
 * $Log: nqsdeflim.h,v $
 * Revision 1.7  1994/03/30  20:31:39  jrroma
 * Version 3.35.6
 *
 * Revision 1.6  92/12/22  15:45:20  jrroma
 * Version 3.30
 * 
 * Revision 1.5  92/06/18  09:46:22  jrroma
 * Added gnu header
 * 
 * Revision 1.4  92/05/06  10:01:56  jrroma
 * Version 3.20
 * 
 * Revision 1.3  92/01/22  13:04:53  jrroma
 * Fix up limits for RS6000.
 * 
 * Revision 1.2  92/01/17  11:43:49  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  11:42:54  jrroma
 * Initial revision
 * 
 *
 */

#if	SYS53
#define DLIM_PPCOREUNITS	QLM_MBYTES
#define DLIM_PPCORECOEFF	0L
#else
#define DLIM_PPCOREUNITS	QLM_BYTES
#define DLIM_PPCORECOEFF	32L
#endif

#if	SYS53
#define DLIM_PPDATAUNITS	QLM_MBYTES
#define DLIM_PPDATACOEFF	0L
#else
#define DLIM_PPDATAUNITS	QLM_BYTES
#define DLIM_PPDATACOEFF	32L
#endif

#define DLIM_PPPFILEUNITS	QLM_MBYTES
#define DLIM_PPPFILECOEFF	500L

#define DLIM_PRPFILEUNITS	QLM_BYTES
#define DLIM_PRPFILECOEFF	0L

#define DLIM_PPQFILEUNITS	QLM_BYTES
#define DLIM_PPQFILECOEFF	0L

#define DLIM_PRQFILEUNITS	QLM_BYTES
#define DLIM_PRQFILECOEFF	0L

#define DLIM_PPTFILEUNITS	QLM_BYTES
#define DLIM_PPTFILECOEFF	0L

#define DLIM_PRTFILEUNITS	QLM_BYTES
#define DLIM_PRTFILECOEFF	0L

#define DLIM_PPMEMUNITS		QLM_BYTES
#define DLIM_PPMEMCOEFF		0L

#define DLIM_PRMEMUNITS		QLM_BYTES
#define DLIM_PRMEMCOEFF		0L

#if	SYS53
#define DLIM_PPSTACKUNITS	QLM_MBYTES
#define DLIM_PPSTACKCOEFF	0L
#else
#define DLIM_PPSTACKUNITS	QLM_BYTES
#define DLIM_PPSTACKCOEFF	32L
#endif

#if	SYS53
#define DLIM_PPWORKUNITS	QLM_MBYTES
#define DLIM_PPWORKCOEFF	0L
#else
#define DLIM_PPWORKUNITS	QLM_BYTES
#define DLIM_PPWORKCOEFF	32L
#endif

#if	SYS53
#define DLIM_PPCPUSECS		0
#define DLIM_PPCPUMS		0
#else
#define DLIM_PPCPUSECS		360000
#define DLIM_PPCPUMS		0
#endif

#define DLIM_PRCPUSECS		0
#define DLIM_PRCPUMS		0

#define DLIM_PPNICE		0

#define DLIM_PRDRIVES		0

#define DLIM_PRNCPUS		0

