/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ serexit.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/serexit.c,v $
 *
 * DESCRIPTION:
 *
 *	Server exit routine.  ALL NQS servers should call this routine
 *	WHENEVER they wish to exit.
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:46:28 $ $State: Exp $)
 * $Log: serexit.c,v $
 * Revision 1.3  1992/12/22  15:46:28  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:24:41  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:48:02  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"		/* NQS types and definitions */
#include <string.h>

/*** serexit
 *
 *
 *	void serexit():
 *
 *	Send a server-complete message to the shepherd process
 *	(parent of the server) on file descriptor 3, and exit(0).
 */
void serexit (long rcm, char servermssg[256])
{
	struct servermssg ret_packet;

	ret_packet.rcm = rcm;	/* Store req/server completion message */
	if (servermssg == (char *)0) ret_packet.mssg [0] = '\0';
	else strcpy (ret_packet.mssg, servermssg);
	/*
	 *  If you change the file descriptor that the req/server
	 *  completion message is reported on, then you must also
	 *  change nqs_spawn.c.
	 */
	write (3, (char *) &ret_packet, sizeof (ret_packet));
	exit (0);		/* Exit */
}
