/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*	V01.2	JRR	???		???
*       V01.3   JRR     12-Feb-1992	Fixed declaration of static routines.
*	V01.4	JRR	17-Jun-1992	Added header.
*	V01.5	JRR	19-Nov-1992	Modified for C prototypes.
*/
/*++ parseserv.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/parseserv.c,v $
 *
 * DESCRIPTION:
 *
 *	This module parses a server invocation command line, placing
 *	the broken-out arguments into the specified argv[] array.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 31, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.4 $ $Date: 1992/12/22 15:46:19 $ $State: Exp $)
 * $Log: parseserv.c,v $
 * Revision 1.4  1992/12/22  15:46:19  jrroma
 * Version 3.30
 *
 * Revision 1.3  92/06/18  13:24:24  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/02/12  14:10:42  jrroma
 * Fixed declaration of static routines.
 * 
 * Revision 1.1  92/02/12  14:09:41  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* NQS constants and data types */
#include <string.h>


#ifndef __CEXTRACT__
#if __STDC__

static char *scanwhite ( char *ch );

#else /* __STDC__ */

static char *scanwhite (/* char *ch */);

#endif /* __STDC__ */
#endif /* __CEXTRACT__ */

/*** parseserv
 *
 *
 *	int parseserv ():
 *	Parse server command line into argv[].
 *
 *	Returns:
 *		0: if successful.
 *	       -1: if there are too many arguments, or the server
 *		   specification is too long.
 */
int parseserv (char *servercmd, char *argv[MAX_SERVERARGS+1])
{

	static char serverspec [MAX_SERVERNAME+1];
					/* Server command and arguments */
	register int i;			/* Index */
	register char *cp;		/* Character pointer */

	if (strlen (servercmd) > MAX_SERVERNAME) return (-1);
	strcpy (serverspec, servercmd);	/* Copy the server command into */
	i = 0;				/* the static buffer area */
	cp = serverspec;
	do {
		cp = scanwhite (cp);	/* Scan white space */
		if (*cp) {
			/*
			 *  We have an argument.
			 */
			argv [i] = cp;	/* Record start of argument */
			do {		/* Scan argument */
				cp++;
			} while (*cp > ' ');
			if (*cp) {
				/*
				 *  Null terminate argument.
				 */
				*cp = '\0';
				cp++;
			}
		}
		i++;
	} while (*cp && i < MAX_SERVERARGS);
	argv [i] = (char *) 0;		/* Null terminate argv[] list */
	cp = scanwhite (cp);
	if (*cp != '\0') {
		/*
		 *  Too many server arguments in server command line.
		 */
		return (-1);
	}
	return (0);			/* Parse was successful */
}


/*** scanwhite
 *
 *
 *	char *scanwhite():
 *
 *	Scan white space returning pointer to first non-white character
 *	or null character.  This function only works for 7-bit ASCII
 *	characters.
 */
static char *scanwhite (char *ch)
{
	while (*ch && *ch <= ' ') ch++;
	return (ch);
}
