/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ readdir.c - 
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/libndir/RCS/readdir.c,v $
 *
 * DESCRIPTION:
 *
 *	Emulate the Berkeley 4.2 UNIX library call of:  readdir (3x)
 *	On top of the System V fixed name length directory structure.
 *
 *
 *	Author:
 *	-------
 *	Kirk McKusick, University of California, Berkeley.
 *	March 10, 1982.
 *
 *	Modifications:
 *	--------------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	September 10, 1985.
 *
 *	  Changed "#include <dir.h>" to read "#include "dir.4.2.h"" since
 *	  we are after the Berkeley definition, and not System V.  Also
 *	  changed olddirect for UNICOS.
 *
 *
 * STANDARDS VIOLATIONS:
 *
 * REVISION HISTORY: ($Revision: 1.4 $ $Date: 1994/03/30 20:34:10 $ $State: Exp $)
 * $Log: readdir.c,v $
 * Revision 1.4  1994/03/30  20:34:10  jrroma
 * Version 3.35.6
 *
 * Revision 1.3  92/06/18  13:33:28  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/03/03  14:13:06  jrroma
 * Used Cosmic V2 version.
 * 
 * Revision 3.2  91/02/11  16:56:29  root
 * Version 2.0 Source
 * 
 * Revision 2.2  87/04/22  14:57:30  hender
 * Sterling version 4/22/87
 * 
 *
 */

#include <sys/types.h>
#if	SYS52| UTS
#include "dir.4.2.h"
#else
#if	BSD43
#include <sys/dir.h>
#else
BAD SYSTEM TYPE
#endif
#endif

/*
 * read an old style directory entry and present it as a new one
 */
#define	ODIRSIZ	14

#if	SYS52 | UTS
struct	olddirect {
	ino_t	od_ino;
	char	od_name[ODIRSIZ];
};
#else
BAD SYSTEM TYPE
#endif

/*** readdir
 *
 *
 *	struct direct *readdir():
 *	Read the next entry in a directory.
 */
struct direct *readdir(dirp)
register DIR *dirp;
{
	register struct olddirect *dp;
	static struct direct dir;

	for (;;) {
		if (dirp->dd_loc == 0) {
			dirp->dd_size = read(dirp->dd_fd, dirp->dd_buf, 
			    DIRBLKSIZ);
			if (dirp->dd_size <= 0) return (NULL);
		}
		if (dirp->dd_loc >= dirp->dd_size) {
			dirp->dd_loc = 0;
			continue;
		}
		dp = (struct olddirect *)(dirp->dd_buf + dirp->dd_loc);
		dirp->dd_loc += sizeof(struct olddirect);
		if (dp->od_ino == 0)
			continue;
		dir.d_ino = dp->od_ino;
		strncpy(dir.d_name, dp->od_name, ODIRSIZ);
		dir.d_name[ODIRSIZ] = '\0'; /* insure null termination */
		dir.d_namlen = strlen(dir.d_name);
		dir.d_reclen = DIRBLKSIZ;
		return (&dir);
	}
}
