/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.2   JRR     28-Feb-1992	Added Cosmic V2 changes.
*	V01.3	JRR	17-Jun-1992	Added header.
*/
/*++ filecopy.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/filecopy.c,v $
 *
 * DESCRIPTION:
 *
 *	Copy a file.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 92/06/18 13:23:45 $ $State: Exp $)
 * $Log:	filecopy.c,v $
 * Revision 1.3  92/06/18  13:23:45  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/02/28  13:59:26  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.1  92/02/28  13:56:26  jrroma
 * Initial revision
 * 
 *
 */

extern int errno;			/* System call error number */

/*** filecopyentire
 *
 *
 *	int filecopyentire():
 *	Copy a file from one open file descriptor to another.
 *	Don't stop until EOF.
 *
 *	Returns:
 *	      >=0: if successful (number of bytes transferred);
 *	       -1: if an error occurs (in which case errno is set).
 *		   Errno will equal zero, if we simply ran out of
 *		   file space writing the copy.
 */
long filecopyentire (from, to)
register int from;			/* "From" file descriptor */
register int to;			/* "To" file descriptor */
{
	char buffer [8192];		/* Copy buffer */
	register int nread;		/* One time number of bytes read */
	register int nwritten;		/* One time number of bytes written */
	register long cumulative;	/* Sum of nwritten's */

	errno = 0;			/* So that file limit returns 0 errno */
	cumulative = 0;
	while ((nread = read (from, buffer, sizeof (buffer))) != 0) {
		if (nread < 0) return (-1L);
		if ((nwritten = write (to, buffer, nread)) != nread)
                {
                        /* TAC the printf is an Intergraph change */
                        printf("E$INTERGRAPH nread=%d, nwritten=%d, errno=%d\n",
                                nread, nwritten, errno);
                        return(-1L);
                }
		cumulative += nwritten;
	}
	return (cumulative);
}


/*** filecopysized
 *
 *
 *	int filecopysized():
 *	Copy a file from one open file descriptor to another.
 *	Stop as soon as the specified number of bytes have been moved.
 *
 *	Returns:
 *	      >=0: if successful, or if it reached a premature EOF
 *		   (number of bytes transferred);
 *	       -1: if an error occurs (in which case errno is set).
 *		   Errno will equal zero, if we simply ran out of
 *		   file space writing the copy.
 */
long filecopysized (from, to, bytes)
register int from;			/* "From" file descriptor */
register int to;			/* "To" file descriptor */
long bytes;				/* How many bytes to move */
{
	char buffer [8192];		/* Copy buffer */
	register int nread;		/* One time number of bytes read */
	register int nwritten;		/* One time number of bytes written */
	register long need;		/* Number of bytes still needed */

	errno = 0;			/* So that file limit returns 0 errno */
	for (need = bytes; need > 0; need -= nwritten) {
		if ((nread = read (from, buffer,
			need < sizeof buffer ? need : sizeof buffer)) != 0) {
			if (nread < 0) return (-1L);
			if ((nwritten = write (to, buffer, nread)) != nread)
				return (-1L);
		}
		else return (bytes - need);
	}
	return (bytes);
}
