/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.20	JRR	17-Jan-1992	Further changes for RS6000.
*	V01.3   JRR     28-Feb-1992	Added Cosmic V2 changes.
*	V01.4	JRR	17-Jun-1992	Added header.
*	V01.5	JRR	23-Feb-1993	Added Boeing enhancement for Mids.
*	V01.6	JRR			Placeholder
*	V01.7	JRR			Placeholder
*	V01.8	JRR	02-Mar-1994	Added support for SOLARIS.
*/
/*++ nmap.h -
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/npsn_compat/RCS/nmap.h,v $
 *
 * DESCRIPTION:
 *	Nmap.h:  This header file contains the definitions of the
 *		 data types and return codes used in the Network
 *		 Mapping procedures in the Nmap library.
 *
 * STANDARDS VIOLATIONS:
 *
 * REVISION HISTORY: ($Revision: 1.8 $ $Date: 1994/03/30 20:35:38 $ $State: Exp $)
 * $Log: nmap.h,v $
 * Revision 1.8  1994/03/30  20:35:38  jrroma
 * Version 3.35.6
 *
 * Revision 1.7  93/07/13  21:33:14  jrroma
 * Version 3.34
 * 
 * Revision 1.6  92/12/22  15:51:38  jrroma
 * Version 3.30
 * 
 * Revision 1.5  92/06/18  14:39:17  jrroma
 * Added gnu header
 * 
 * Revision 1.4  92/02/28  13:18:27  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.3  92/01/17  16:06:55  jrroma
 * Further tweak for RS6000.
 * 
 * Revision 1.2  92/01/17  12:51:08  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  12:50:28  jrroma
 * Initial revision
 * 
 *
 */


#ifndef _NQS_NMAPH_
#define _NQS_NMAPH_
#include <sys/types.h>

/*
 *
 *	Data types:
 */
typedef	unsigned long Mid_t;	/* Machine-id type.		*/
#if	SYS52
typedef unsigned short uid_t;	/* User-id type.		*/
typedef unsigned short gid_t;	/* Group-id type.		*/
#else
#if	BSD43 | HPUX | ULTRIX | DECOSF | SGI | SOLARIS | IBMRS 
			/* uid_t and gid_t defined in <sys/types.h> */
#else
BAD SYSTEM TYPE
#endif
#endif

/*
 *
 *	Return codes:
 */
#define	NMAP_SUCCESS	 0	/* Success!			*/
#define	NMAP_DEFMAP	 1	/* No uid(gid) mapping existed.	*/
				/* The default uid(gid) mapping	*/
				/* for the specified machine has*/
				/* been returned.		*/
#define	NMAP_EUNEXPECT	-1	/* Serious major error; like	*/
				/* EMFILE or ENFILE, or one of	*/
				/* mapping files is screwed up;	*/
				/* Something that should have	*/
				/* worked, did not.		*/
#define NMAP_ENOPRIV	-2	/* Insufficient privilege to	*/
				/* access or update mapping	*/
				/* database.			*/
#define	NMAP_ECONFLICT	-3	/* Machine already exists or an	*/
				/* attempt was made to add a	*/
				/* uid(gid) mapping which	*/
				/* already existed on the target*/
				/* machine and the new mapping	*/
				/* differed from the existing	*/
				/* mapping.			*/
#define	NMAP_ENOMAP	-4	/* No mapping exists.		*/
#define	NMAP_ENOMID	-5	/* No machine as specified by	*/
				/* the mid parameter in the call*/
				/* exists.			*/
#define	NMAP_EBADNAME	-6	/* Bad name specified.		*/
/*
 *
 *	nmap_ctl opcodes:
 */
#define	NMAP_OPNOFD	0	/* Set number of file descriptors */
#define	NMAP_OPUIDC	1	/* Set uid cache size */
#define	NMAP_OPGIDC	2	/* Set gid cache size */
#define	NMAP_OPNAMC	3	/* Set name cache size */

#include "nmapdb.h"
#include "nmap_proto.h"
#endif  /* _NQS_NMAPH_ */
