/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.1   JRR     24-Aug-1992     Initial version.
*	V01.2	JRR	18-Aug-1993	Clean up includes.
*/
/*++ mgr_memdump.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/src/RCS/mgr_memdump.c,v $
 *
 * DESCRIPTION
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 1993/09/10 13:56:55 $ $State: Exp $)
 * $Log: mgr_memdump.c,v $
 * Revision 1.2  1993/09/10  13:56:55  jrroma
 * Version 3.35
 *
 * Revision 1.1  92/12/22  15:39:25  jrroma
 * Version 3.30
 * 
 * 
 *
 */

#include "nqs.h"			/* NQS types and definitions */
#include <unistd.h>
#include <errno.h>
#include "nqspacket.h"
#include "nqsxvars.h"			/* NQS external vars */
#include "transactcc.h"                 /* For TCML_COMPLETE */

int memdump (flags)
char *flags;
{
    int	dump_flag;
    int status;
    int fifo_fd;
    char *cp;

    for (cp = flags; *cp != '\0'; cp++) {
	*cp = tolower(*cp);
    }
    
    if ( !(strncmp (flags, "load", 4)) ) {
	dump_flag = MEMDUMP_LOAD;
    } else if ( !strncmp (flags, "req", 3)) {
	dump_flag = MEMDUMP_REQ;
    } else dump_flag = 0;

    interclear();
    interw32i( (long) dump_flag );
    return( inter (PKT_MEMDUMP) );
}

