/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	07-Dec-1992	Modified for C Prototypes.
*/
/*++ namstderr.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/namstderr.c,v $
 *
 * DESCRIPTION:
 *
 *	Return pointer to name of spooled stderr output file for
 *	a batch request.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.4 $ $Date: 1992/12/22 15:46:16 $ $State: Exp $)
 * $Log: namstderr.c,v $
 * Revision 1.4  1992/12/22  15:46:16  jrroma
 * Version 3.30
 *
 * Revision 1.3  92/06/18  13:24:15  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  16:53:58  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  16:53:11  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* For MAX_OUTPSUBDIRS */
#include "nqsxdirs.h"
#include <string.h>


/*** namstderr
 *
 *
 *	char *namstderr():
 *
 *	Return pointer to name of spooled stderr output file for
 *	a batch request.
 *
 *	NOTE:	The name is computed relative to the NQS root directory.
 */
char *namstderr (orig_seqno, orig_mid)
long orig_seqno;			/* Req sequence number */
Mid_t orig_mid;				/* Req machine-id */
{
	static char path [48];		/* Pathname for file.  This size */
					/* may need to be increased.... */

	pack6name (path, Nqs_output, (int) (orig_seqno % MAX_OUTPSUBDIRS),
		  (char *) 0, (long) orig_seqno, 5, (long) orig_mid, 6, 0, 0);
	strcat (path, "e");
	return (path);
}
