/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.30  JRR     17-Jan-1992	Minor tweak to the above.
*       V01.4   JRR     28-Feb-1992	Added Cosmic V2 changes.
*       V01.5   JRR     18-Mar-1992	Fixed call to this routine.
*	V01.6	JRR	17-Jun-1992	Added header.
*	V01.7	JRR	06-Nov-1992	Modified for C prototypes.
*	V01.8	JRR	01-Dec-1992	Slight twiddle to above.
*	V01.9	JRR	23-Feb-1993	Added Boeing enahancement for Mids.
*/
/*++ movreq.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.34/lib/RCS/movreq.c,v $
 *
 * DESCRIPTION:
 *
 *	Send a move request packet to the NQS daemon.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	December 2, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.9 $ $Date: 1993/07/13 21:31:29 $ $State: Exp $)
 * $Log: movreq.c,v $
 * Revision 1.9  1993/07/13  21:31:29  jrroma
 * Version 3.34
 *
 * Revision 1.8  92/12/22  15:46:15  jrroma
 * Version 3.30
 * 
 * Revision 1.7  92/11/06  13:44:20  jrroma
 * Modified for C prototypes.
 * 
 * Revision 1.6  92/06/18  13:24:14  jrroma
 * Added gnu header
 * 
 * Revision 1.5  92/03/20  10:54:45  jrroma
 * Done.
 * 
 * Revision 1.4  92/02/28  15:10:54  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.3  92/01/17  16:32:11  jrroma
 * Tweak to support for RS6000.
 * 
 * Revision 1.2  92/01/16  16:52:43  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  16:51:55  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqspacket.h"			/* NQS local message packets */

/*** movreq
 *
 *
 *	long movreq():
 *	Send a move request packet to the NQS daemon.
 *
 *	Returns:
 *		TCML_COMPLETE:	 if the specified request was
 *				 successfully placed in the specified
 *				 queue.
 *		TCML_INTERNERR:	 if maximum packet size exceeded.
 *		TCML_NOESTABLSH: if unable to establish inter-
 *				 process communication.
 *		TCML_NOLOCALDAE: if the NQS daemon is not running.
 *		TCML_NOSUCHQUE:	 if the specified from or destination
 *				 queue does not exist.
 *		TCML_NOSUCHREQ:	 if the specified request does not
 *				 exist.
 *		TCML_NOTREQOWN:	 if the specified request is not
 *				 owned by the client.
 *		TCML_PROTOFAIL:	 if a protocol failure occurred.
 */
long movreq (orig_seqno, orig_mid, dest_queue_name)
long orig_seqno;			/* Original sequence# */
Mid_t orig_mid;				/* Original machine-id of req */
char *dest_queue_name;			/* Name of destination queue for */
{					/* the request */
	interclear();
	interw32i ((long) orig_seqno);
	interw32u (orig_mid);
	interwstr (dest_queue_name);
	return (inter (PKT_MOVREQ));
}
