/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*	V01.2	JRR	17-Jun-1992	Added header.
*	V01.3	JRR	02-Oct-1992	Added include of stdio.h for TRUE.
*					Added support for HPUX.
*	V01.4	JRR	23-Dec-1992	Make sure NULL is defined.
*	V01.5	JRR	06-Apr-1993	Added support for DECOSF.
*/
/*++ list_nqs_queues.c - Network Queueing System
 *
 */

#include "nqs.h"
#include "nqsxdirs.h"			/* NQS files and directories */


/*
 *	Global variables:
 */
int DEBUG = 0;
/*
 *  int list_nqs_queues ( char * queptr, int count)
 *
 *  This routine will return the names of all the NQS queues on the 
 *  system in a character buffer.
 *
 */
int
list_nqs_queues(queptr,  count)
char *queptr;				/* Pointer to buffer to get names */
int count;				/* Maximum number we will take */
{
	struct confd *queuefile;	/* Queue description file */
	register struct gendescr *descr;
	char	*cptr;			/* Pointer to buffer entries */
	int	i;			/* Counter of entries put into buffer */

	if (chdir (Nqs_root) == -1) {
		return(-1);
	}
#ifndef		NULL
#define		NULL	0
#endif
	if ((queuefile = opendb (Nqs_queues, O_RDONLY)) == NULL) {
		return(-2);
	}
	cptr = queptr;
	i = 0;
	descr = nextdb(queuefile);
	while (descr != (struct gendescr *)0) {
	    if ( (i+1) > count) break;	/* If will overrun, leave the loop */
	    i++;			/* Another entry in the table */
	    strcpy(cptr,  descr->v.que.namev.name);
	    cptr += MAX_QUEUENAME+1;	/* Advance to the next entry */
            descr = nextdb (queuefile);  /* Get the next queue */
        }
	return(i);
}
