/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.0   CB                      Initial version.
*       V01.10  JRR     26-May-1992	Fixed support for RS6000.
*	V01.2	JRR	17-Jun-1992	Added header.
*	V01.3	JRR	06-Nov-1992	Added support for C prototypes.
*	V01.4	JRR	01-Sep-1993	Fix support for Mids as unsigned ints.
*	V01.5	JRR			Placeholder
*	V01.6	JRR	03-Mar-1994	Fixed up NMAP.
*/
/*++ hdlreq.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/hdlreq.c,v $
 *
 * DESCRIPTION:
 *
 *	Handle (hold or release) a NQS request.
 *
 *
 *	Author:
 *	-------
 *	Christian Boissat, CERN, Geneva, Switzerland.
 *	January 6, 1992.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1994/03/30 20:32:31 $ $State: Exp $)
 * $Log: hdlreq.c,v $
 * Revision 1.6  1994/03/30  20:32:31  jrroma
 * Version 3.35.6
 *
 * Revision 1.5  93/09/10  13:55:12  jrroma
 * Version 3.35
 * 
 * Revision 1.4  92/11/06  13:15:07  jrroma
 * Modified for C prototypes.
 * 
 * Revision 1.3  92/06/18  13:23:55  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/06/18  09:41:41  jrroma
 * Version 3.21
 * 
 * Revision 1.1  92/05/06  10:11:41  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqspacket.h"			/* NQS local message packets */
#include "nmap.h"				/* Mid_t (all OS's) */
					/* Uid_t and gid_t (if not BSD43) */

/*** hdlreq
 *
 *
 *	long hdlreq():
 *
 *	Send to the NQS daemon a packet which will hold or release a
 *	request.
 *
 *	Returns:
 *		TCML_COMPLETE:	 if successful;
 *		TCML_NOSUCHREQ:	 if request does not exist.
 *		TCML_REQRUNNING: if the request is running, and has
 *				 not been signalled.
 */
long hdlreq (oper, whomuid, req_seqno, req_mid)
int oper;			/* Type of operation (hold or release) */
uid_t whomuid;			/* Calling user, else zero for */
				/* NQS operator/manager call  */
int req_seqno;			/* Request sequence number */
Mid_t req_mid;			/* Request machine id */
{
	interclear();
	interw32i ((long) whomuid);
	interw32i ((long) req_seqno);
	interw32u ((Mid_t) req_mid);
	return (inter (oper == 0 ? PKT_HOLDREQ : PKT_RELREQ));
}
