/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     07-Apr-1992	Added CERN enhancements.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	01-Dec-1992	Modified for C prototypes.
*	V01.5	JRR	18-Aug-1993	Miniscule change to includes
*/
/*++ nextseqno.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/lib/RCS/nextseqno.c,v $
 *
 * DESCRIPTION:
 *
 *	Return the next available NQS request sequence number.
 *	The current directory of the caller MUST be the NQS
 *	root directory.
 *
 *	For the reasons behind the peculiar storage of the
 *	NQS request sequence number, see ../src/nqs_ldconf.c.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	March 20, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.5 $ $Date: 1993/09/10 13:55:17 $ $State: Exp $)
 * $Log: nextseqno.c,v $
 * Revision 1.5  1993/09/10  13:55:17  jrroma
 * Version 3.35
 *
 * Revision 1.4  92/12/22  15:46:18  jrroma
 * Version 3.30
 * 
 * Revision 1.3  92/06/18  13:24:17  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/05/06  10:12:48  jrroma
 * Version 3.20
 * 
 * Revision 1.1  92/04/07  13:41:08  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsxdirs.h"			/* Get Nqs_seqno definition */

/*** nextseqno
 *
 *
 *	long nextseqno():
 *
 *	Return the next available NQS request sequence number.
 *	The current directory of the caller MUST be the NQS
 *	root directory.
 */
long nextseqno ()
{
	struct stat stat_buf;		/* Stat() buffer */

	if (stat (Nqs_seqno, &stat_buf) == -1) return (0);
	if ((stat_buf.st_mode & 0777) == 0) return (0);
	return ((long) stat_buf.st_mtime);
}
