/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ isdecstr.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/isdecstr.c,v $
 *
 * DESCRIPTION:
 *
 *	Determine if a string of length n characters contains
 *	ASCII decimal digit characters and nothing but ASCII
 *	decimal digit characters.
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:23:58 $ $State: Exp $)
 * $Log:	isdecstr.c,v $
 * Revision 1.2  92/06/18  13:23:58  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  10:19:14  jrroma
 * Initial revision
 * 
 *
 */

/*** isdecstr
 *
 *
 *	int isdecstr():
 *
 *	Returns:
 *		1: if the specified string of length n characters
 *		   contains decimal digits and nothing but decimal digits;
 *		0: otherwise.
 */
int isdecstr (char *name, int len)
{
	if (len <= 0) return (0);
	while (len && *name >= '0' && *name <= '9') {
		len--;
		name++;
	}
	if (len == 0) return (1);
	return (0);
}
