/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ freedb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/freedb.c,v $
 *
 * DESCRIPTION:
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:46:01 $ $State: Exp $)
 * $Log: freedb.c,v $
 * Revision 1.3  1992/12/22  15:46:01  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:23:49  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  10:17:57  jrroma
 * Initial revision
 * 
 *
 */
#include "nqs.h"
#include <errno.h>

/*** freedb
 *
 *
 *	void freedb():
 *
 *	Free the descriptor entry at the specified file offset
 *	in the specified NQS database/configuration file.  The
 *	current position of the database file is placed at the
 *	descriptor record FOLLOWING the deleted descriptor.
 */
void freedb (struct confd *file, long position)
{
	register struct gendescr *descr1;
	register struct gendescr *descr2;
	register long offset;
	register long doffset;

	offset = position % ATOMICBLKSIZ;	/* Offset within block */
	descr1 = (struct gendescr *) file->cache->v.chars;
	seekdbb (file, position);	/* Set virtual position to reference */
					/* descriptor targeted for deletion. */
	if (offset) {
		/*
		 *  Merge deleted descriptor with the previous descriptor
		 *  in the block.
		 */
		doffset = descr1->size;
		if (doffset < 0) {
			/*
			 *  The very first descriptor in the block is free.
			 *  (Only the size of the very FIRST descriptor in
			 *   a block can be negative).
			 */
			doffset = -doffset;
		}
		while (doffset < offset) {
			/*
			 *  We still have not found the descriptor immediately
			 *  previous to the descriptor that we are trying to
			 *  delete.
			 */
			descr1 = (struct gendescr *)
				 (file->cache->v.chars + doffset);
			doffset += descr1->size;
		}
		/*
		 *  Descr1 now points at the descriptor immediately previous
		 *  to the descriptor being deleted.
		 */
		descr2 = (struct gendescr *) (file->cache->v.chars+offset);
		file->vposition += descr2->size;/* Position at next descr */
		/*
		 *  Merge the deleted descriptor with the previous descriptor.
		 */
		if (descr1->size < 0) {
			descr1->size -= descr2->size;
		}
		else descr1->size += descr2->size;
	}
	else {
		file->vposition += descr1->size;/* Position at next descr */
		descr1->size = -descr1->size;	/* Mark descriptor at head of */
						/* block as free */
	}
	/*
	 *  File->vposition has the position of the next descriptor after
	 *  the deleted descriptor in the database file.
	 *  Now, rewrite the updated block.
	 */
	lseek (file->fd, file->rposition - ATOMICBLKSIZ, 0);
						/* Seek back to block */
	errno = 0;				/* Set to zero so partial */
						/* writes do not give spurious*/
						/* error message in nqs_abort.*/
	if (write (file->fd, file->cache->v.chars,
		   ATOMICBLKSIZ) != ATOMICBLKSIZ) {
		printf ("F$Write error in freedb().\n");
		nqs_abort();
	}
}
